/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.HashMap;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.NullPaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoGetter;
import jp.sourceforge.concierge.plugin.ipapers.search.ieice.IEICECore;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;

public class PaperInfoFactory {
    private static final PaperInfoFactory singleton = new PaperInfoFactory();
    private HashMap<String, PaperInfoGetter> infoGetterMap = new HashMap();

    public static PaperInfoFactory getInstance() {
        return singleton;
    }

    private PaperInfoFactory() {
        this.addNewInfoGetter(new PubMedCore());
        this.addNewInfoGetter(new IEICECore());
    }

    private void addNewInfoGetter(PaperInfoGetter infoGetter) {
        this.infoGetterMap.put(infoGetter.getIdType(), infoGetter);
    }

    public PaperInfo create(String id, String idType) throws CannotGetPaperInfoException {
        if (this.infoGetterMap.containsKey(idType)) {
            PaperInfo info = this.infoGetterMap.get(idType).fetchInfo(id);
            return info;
        }
        return new NullPaperInfo();
    }
}

