/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.base;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String WHITE_SPACES = " \r\n\t\u3000\u00a0\u2007\u202f";
    public static final String LINE_BREAKS = "\r\n";
    private static final Pattern htmlTagPattern = Pattern.compile("</?[a-zA-Z][^>]*>");
    private static final Pattern characterReferencePattern = Pattern.compile("&#?[a-zA-Z0-9]{1,8};");
    private static final Pattern dbSpecPattern = Pattern.compile("(.*)\\{(\\d+),(\\d+)\\}(.*)");
    static Map<String, Character> escapeStrings = new HashMap<String, Character>(252);
    private static final String[] UNSAFE_TAGS;
    private static final Set<Character.UnicodeBlock> CJK_BLOCKS;
    private static char[] hexChars;

    private StringUtil() {
    }

    public static String[] split(String string, String string2) {
        return StringUtil.split(string, string2, false);
    }

    public static String[] split(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = bl ? stringTokenizer.nextToken().trim() : stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] splitAndTrim(String string, String string2) {
        return StringUtil.split(string, string2, true);
    }

    public static int[] splitInts(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray;
    }

    public static long[] splitLongs(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            lArray[i] = Long.parseLong(string2);
        }
        return lArray;
    }

    public static String joinInts(int[] nArray, String string) {
        if (nArray == null) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0 && string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(String.valueOf(nArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String joinLongs(long[] lArray, String string) {
        if (lArray == null) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0 && string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(String.valueOf(lArray[i]));
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String join(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0 && string != null) {
                stringBuilder.append(string);
            }
            if (objectArray[i] == null) continue;
            stringBuilder.append(objectArray[i].toString());
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String join(Collection collection, String string) {
        return StringUtil.join(collection.toArray(), string);
    }

    @Deprecated
    public static String replace(String string, String string2, String string3) {
        assert (string2.length() > 0);
        return string.replace(string2, string3);
    }

    public static String fixedWidth(String string, int n) {
        String[] stringArray = StringUtil.split(string, "\n");
        return StringUtil.fixedWidth(stringArray, n);
    }

    public static String fixedWidth(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = 0;
            if (i != 0) {
                stringBuilder.append("\n");
            }
            if (stringArray[i].length() <= n) {
                stringBuilder.append(stringArray[i]);
                continue;
            }
            String[] stringArray2 = StringUtil.splitAndTrim(stringArray[i], WHITE_SPACES);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (n2 == 0 || n2 + stringArray2[j].length() < n) {
                    if (n2 != 0) {
                        stringBuilder.append(" ");
                        ++n2;
                    }
                    n2 += stringArray2[j].length();
                    stringBuilder.append(stringArray2[j]);
                    continue;
                }
                stringBuilder.append("\n");
                n2 = stringArray2[j].length();
                stringBuilder.append(stringArray2[j]);
            }
        }
        return stringBuilder.toString();
    }

    public static String insertBreakingWhitespace(int n, String string) {
        if (string == null || n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 - n3 > n) {
            stringBuilder.append(string.substring(n3, n3 + n));
            n3 += n;
            stringBuilder.append(" ");
        }
        stringBuilder.append(string.substring(n3, n2));
        return stringBuilder.toString();
    }

    public static String indent(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        return StringUtil.replace(string, "\n", stringBuilder.toString());
    }

    public static String megastrip(String string, boolean bl, boolean bl2, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length() - 1;
        for (n = 0; bl && n <= n2 && string2.indexOf(string.charAt(n)) >= 0; ++n) {
        }
        while (bl2 && n2 >= n && string2.indexOf(string.charAt(n2)) >= 0) {
            --n2;
        }
        return string.substring(n, n2 + 1);
    }

    public static String lstrip(String string) {
        return StringUtil.megastrip(string, true, false, WHITE_SPACES);
    }

    public static String rstrip(String string) {
        return StringUtil.megastrip(string, false, true, WHITE_SPACES);
    }

    public static String strip(String string) {
        return StringUtil.megastrip(string, true, true, WHITE_SPACES);
    }

    public static String stripAndCollapse(String string) {
        return StringUtil.collapseWhitespace(StringUtil.strip(string));
    }

    public static String stripPrefix(String string, String string2) {
        return string.startsWith(string2) ? string.substring(string2.length()) : null;
    }

    public static String stripPrefixIgnoreCase(String string, String string2) {
        if (string.length() >= string2.length() && string.substring(0, string2.length()).equalsIgnoreCase(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }

    public static String stripNonDigits(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (char c : string.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int numSharedChars(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = StringUtil.indexOfChars(string, string2, n2 + 1)) != -1) {
            ++n;
        }
        return n;
    }

    public static int indexOfChars(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            if (string2.indexOf(string.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfChars(String string, String string2) {
        return StringUtil.indexOfChars(string, string2, 0);
    }

    public static int lastIndexNotOf(String string, String string2, int n) {
        for (int i = n = Math.min(n, string.length() - 1); i >= 0; --i) {
            if (string2.indexOf(string.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static String replaceChars(String string, String string2, char c) {
        int n = StringUtil.indexOfChars(string, string2);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        do {
            stringBuilder.setCharAt(n, c);
        } while ((n = StringUtil.indexOfChars(string, string2, n + 1)) != -1);
        return stringBuilder.toString();
    }

    public static String removeChars(String string, String string2) {
        int n = StringUtil.indexOfChars(string, string2);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        do {
            stringBuilder.append(string.substring(n2, n));
        } while ((n = StringUtil.indexOfChars(string, string2, n2 = n + 1)) != -1);
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2));
        }
        return stringBuilder.toString();
    }

    public static String retainAllChars(String string, String string2) {
        int n = StringUtil.indexOfChars(string, string2);
        if (n == -1) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(string.charAt(n));
        } while ((n = StringUtil.indexOfChars(string, string2, n + 1)) != -1);
        return stringBuilder.toString();
    }

    public static String replaceSmartQuotes(String string) {
        string = StringUtil.replaceChars(string, "\u0091\u0092\u2018\u2019", '\'');
        string = StringUtil.replaceChars(string, "\u0093\u0094\u201c\u201d", '\"');
        return string;
    }

    public static byte[] hexToBytes(String string) {
        byte[] byArray = new byte[(string.length() + 1) / 2];
        if (string.length() == 0) {
            return byArray;
        }
        byArray[0] = 0;
        int n = string.length() % 2;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!StringUtil.isHex(c)) {
                throw new IllegalArgumentException("string contains non-hex chars");
            }
            if (n % 2 == 0) {
                byArray[n >> 1] = (byte)(StringUtil.hexValue(c) << 4);
            } else {
                int n2 = n >> 1;
                byArray[n2] = (byte)(byArray[n2] + (byte)StringUtil.hexValue(c));
            }
            ++n;
        }
        return byArray;
    }

    public static String convertEOLToLF(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '\r') continue;
            stringBuilder.append(cArray, n, i - n);
            stringBuilder.append('\n');
            if (i + 1 < n2 && cArray[i + 1] == '\n') {
                ++i;
            }
            n = i + 1;
        }
        if (n == 0) {
            return string;
        }
        stringBuilder.append(cArray, n, n2 - n);
        return stringBuilder.toString();
    }

    @Deprecated
    public static String convertEOLToCRLF(String string) {
        return string.replaceAll("(\r\n|\r|\n)", LINE_BREAKS);
    }

    public static String padLeft(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String padRight(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n - string.length();
        stringBuilder.append(string);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String maskLeft(String string, int n, char c) {
        if (n <= 0) {
            return string;
        }
        n = Math.min(n, string.length());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String maskRight(String string, int n, char c) {
        if (n <= 0) {
            return string;
        }
        n = Math.min(n, string.length());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, string.length() - n));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static String unescapeCString(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\' && n2 < n) {
                c = string.charAt(n2++);
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case '?': {
                        c = '?';
                        break;
                    }
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    default: {
                        int n3;
                        if (c == 'x' && n2 < n && StringUtil.isHex(string.charAt(n2))) {
                            n3 = StringUtil.hexValue(string.charAt(n2++));
                            if (n2 < n && StringUtil.isHex(string.charAt(n2))) {
                                n3 = n3 * 16 + StringUtil.hexValue(string.charAt(n2++));
                            }
                            c = (char)n3;
                            break;
                        }
                        if (StringUtil.isOctal(c)) {
                            n3 = c - 48;
                            if (n2 < n && StringUtil.isOctal(string.charAt(n2))) {
                                n3 = n3 * 8 + (string.charAt(n2++) - 48);
                            }
                            if (n2 < n && StringUtil.isOctal(string.charAt(n2))) {
                                n3 = n3 * 8 + (string.charAt(n2++) - 48);
                            }
                            c = (char)n3;
                            break;
                        }
                        stringBuilder.append('\\');
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String unescapeMySQLString(String string) throws IllegalArgumentException {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2 || cArray[0] != cArray[cArray.length - 1] || cArray[0] != '\'' && cArray[0] != '\"') {
            throw new IllegalArgumentException("not a valid MySQL string: " + string);
        }
        int n = 1;
        int n2 = 0;
        for (int i = 1; i < cArray.length - 1; ++i) {
            if (n2 == 0) {
                if (cArray[i] == '\\') {
                    n2 = 1;
                    continue;
                }
                if (cArray[i] == cArray[0]) {
                    n2 = 2;
                    continue;
                }
                cArray[n++] = cArray[i];
                continue;
            }
            if (n2 == 1) {
                switch (cArray[i]) {
                    case '0': {
                        cArray[n++] = '\u0000';
                        break;
                    }
                    case '\'': {
                        cArray[n++] = 39;
                        break;
                    }
                    case '\"': {
                        cArray[n++] = 34;
                        break;
                    }
                    case 'b': {
                        cArray[n++] = 8;
                        break;
                    }
                    case 'n': {
                        cArray[n++] = 10;
                        break;
                    }
                    case 'r': {
                        cArray[n++] = 13;
                        break;
                    }
                    case 't': {
                        cArray[n++] = 9;
                        break;
                    }
                    case 'z': {
                        cArray[n++] = 26;
                        break;
                    }
                    case '\\': {
                        cArray[n++] = 92;
                        break;
                    }
                    default: {
                        cArray[n++] = cArray[i];
                    }
                }
                n2 = 0;
                continue;
            }
            if (cArray[i] != cArray[0]) {
                throw new IllegalArgumentException("not a valid MySQL string: " + string);
            }
            cArray[n++] = cArray[0];
            n2 = 0;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("not a valid MySQL string: " + string);
        }
        return new String(cArray, 1, n - 1);
    }

    public static final String unescapeHTML(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != '&') {
                cArray2[n++] = cArray[n2++];
                continue;
            }
            int n3 = n2 + 1;
            if (n3 < cArray.length && cArray[n3] == '#') {
                ++n3;
            }
            while (n3 < cArray.length && Character.isLetterOrDigit(cArray[n3])) {
                ++n3;
            }
            boolean bl = false;
            if (n3 < cArray.length && cArray[n3] == ';') {
                if (string.charAt(n2 + 1) == '#') {
                    try {
                        long l = 0L;
                        char c = string.charAt(n2 + 2);
                        if (c == 'x' || c == 'X') {
                            l = Long.parseLong(new String(cArray, n2 + 3, n3 - n2 - 3), 16);
                        } else if (Character.isDigit(c)) {
                            l = Long.parseLong(new String(cArray, n2 + 2, n3 - n2 - 2));
                        }
                        if (l > 0L && l < 65536L) {
                            cArray2[n++] = (char)l;
                            bl = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    String string2 = new String(cArray, n2, n3 - n2 + 1);
                    Character c = escapeStrings.get(string2);
                    if (c != null) {
                        cArray2[n++] = c.charValue();
                        bl = true;
                    }
                }
                ++n3;
            }
            if (!bl) {
                System.arraycopy(cArray, n2, cArray2, n, n3 - n2);
                n += n3 - n2;
            }
            n2 = n3;
        }
        return new String(cArray2, 0, n);
    }

    public static String stripHtmlTags(String string) {
        if (string == null || EMPTY_STRING.equals(string)) {
            return string;
        }
        return htmlTagPattern.matcher(string).replaceAll(EMPTY_STRING);
    }

    public static String pythonEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String javaScriptEscape(String string) {
        return StringUtil.javaScriptEscapeHelper(string, false);
    }

    public static String javaScriptEscapeToAscii(String string) {
        return StringUtil.javaScriptEscapeHelper(string, true);
    }

    private static String javaScriptEscapeHelper(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 9 / 8);
        block13: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block13;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block13;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block13;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block13;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block13;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block13;
                }
                case '=': {
                    StringUtil.appendHexJavaScriptRepresentation(stringBuilder, c);
                    continue block13;
                }
                case '/': 
                case '<': {
                    boolean bl2 = false;
                    for (String string2 : UNSAFE_TAGS) {
                        if (!string.regionMatches(true, i + 1, string2, 0, string2.length())) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        StringUtil.appendHexJavaScriptRepresentation(stringBuilder, c);
                        continue block13;
                    }
                    stringBuilder.append(c);
                    continue block13;
                }
                case '>': {
                    if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '-') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    continue block13;
                }
                case '\u2028': {
                    stringBuilder.append("\\u2028");
                    continue block13;
                }
                case '\u2029': {
                    stringBuilder.append("\\u2029");
                    continue block13;
                }
                default: {
                    if (c >= '\u0080' && bl) {
                        StringUtil.appendHexJavaScriptRepresentation(stringBuilder, c);
                        continue block13;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static void appendHexJavaScriptRepresentation(StringBuilder stringBuilder, char c) {
        stringBuilder.append("\\u");
        String string = Integer.toHexString(c);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    public static String javaScriptUnescape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                n = StringUtil.javaScriptUnescapeHelper(string, n + 1, stringBuilder);
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static int javaScriptUnescapeHelper(String string, int n, StringBuilder stringBuilder) {
        if (n >= string.length()) {
            throw new IllegalArgumentException("End-of-string after escape character in [" + string + "]");
        }
        char c = string.charAt(n++);
        switch (c) {
            case 'n': {
                stringBuilder.append('\n');
                break;
            }
            case 'r': {
                stringBuilder.append('\r');
                break;
            }
            case 't': {
                stringBuilder.append('\t');
                break;
            }
            case '\"': 
            case '\'': 
            case '>': 
            case '\\': {
                stringBuilder.append(c);
                break;
            }
            case 'u': {
                int n2;
                String string2;
                try {
                    string2 = string.substring(n, n + 4);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + string.substring(n) + "] at index " + n + " in [" + string + "]");
                }
                try {
                    n2 = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid unicode sequence [" + string2 + "] at index " + n + " in [" + string + "]");
                }
                stringBuilder.append((char)n2);
                n += 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown escape code [" + c + "] at index " + n + " in [" + string + "]");
            }
        }
        return n;
    }

    public static String xmlContentEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String xmlSingleQuotedEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append("&#xA;");
                    continue block7;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String javaEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block11;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block11;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block11;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block11;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String javaEscapeWithinAttribute(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block11;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block11;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block11;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block11;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String xmlEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block8;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '\u0000': {
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String htmlEscape(String string) {
        StringBuilder stringBuilder = null;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            switch (string.charAt(i)) {
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string.length() + string2.length() - 1);
            }
            if (i > n) {
                stringBuilder.append(string.substring(n, i));
            }
            stringBuilder.append(string2);
            n = i + 1;
        }
        if (n > 0) {
            stringBuilder.append(string.substring(n));
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return string;
    }

    public static String regexEscape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("()|*+?.{}[]$^\\".indexOf(c) != -1) {
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String javaUtilRegexEscape(String string) {
        if (string.indexOf("\\E") == -1) {
            return "\\Q" + string + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append('\\');
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String regexReplacementEscape(String string) {
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '\\': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(0, i));
                    }
                    stringBuilder.append('\\');
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static String cropBetween(String string, char c) {
        return StringUtil.cropBetween(string, String.valueOf(new char[]{c}));
    }

    public static String cropBetween(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string2.length();
        boolean bl = true;
        int n3 = -1;
        while ((n3 = string.indexOf(string2, n)) >= 0) {
            if (bl) {
                stringBuilder.append(string.substring(n, n3));
            }
            bl = !bl;
            n = n3 + n2;
        }
        if (bl) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    public static LinkedList<String> string2List(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        StringUtil.string2Collection(string, string2, bl, linkedList);
        return linkedList;
    }

    public static Set string2Set(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        StringUtil.string2Collection(string, string2, bl, hashSet);
        return hashSet;
    }

    public static Collection<String> string2Collection(String string, String string2, boolean bl, Collection<String> collection) {
        String string3;
        int n;
        if (string == null) {
            return null;
        }
        if (collection == null) {
            collection = new ArrayList<String>();
        }
        if (string2 == null || string2.length() == 0) {
            collection.add(string);
            return collection;
        }
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            string3 = string.substring(n2, n);
            if (bl) {
                string3 = StringUtil.strip(string3);
            }
            if (!bl || string3.length() > 0) {
                collection.add(string3);
            }
            n2 = n + string2.length();
        }
        string3 = string.substring(n2);
        if (bl) {
            string3 = StringUtil.strip(string3);
        }
        if (!bl || string3.length() > 0) {
            collection.add(string3);
        }
        return collection;
    }

    @Deprecated
    public static String list2String(Collection<?> collection, String string) {
        return StringUtil.Collection2String(collection, string);
    }

    @Deprecated
    public static String Collection2String(Collection<?> collection, String string) {
        if (collection == null) {
            return null;
        }
        return StringUtil.Iterator2String(collection.iterator(), string);
    }

    @Deprecated
    public static String Iterator2String(Iterator<?> iterator, String string) {
        if (iterator == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    public static HashMap<String, String> string2Map(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (StringUtil.isEmpty(string2) || StringUtil.isEmpty(string3)) {
            hashMap.put(StringUtil.strip(string), EMPTY_STRING);
            return hashMap;
        }
        Iterator iterator = StringUtil.string2List(string, string2, false).iterator();
        int n = string3.length();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            int n2 = string4.indexOf(string3);
            if (n2 > 0) {
                String string5 = string4.substring(n2 + n);
                if (bl) {
                    string5 = StringUtil.strip(string5);
                }
                hashMap.put(StringUtil.strip(string4.substring(0, n2)), string5);
                continue;
            }
            hashMap.put(StringUtil.strip(string4), EMPTY_STRING);
        }
        return hashMap;
    }

    public static <K, V> String map2String(Map<K, V> map, String string, String string2) {
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string2);
            }
            Map.Entry<K, V> entry = iterator.next();
            stringBuilder.append(entry.getKey() + string + entry.getValue());
        }
        return stringBuilder.toString();
    }

    public static <V> Map lowercaseKeys(Map<String, V> map) {
        HashMap<String, V> hashMap = new HashMap<String, V>(map.size());
        for (String string : map.keySet()) {
            if (hashMap.containsKey(string.toLowerCase())) {
                throw new IllegalArgumentException("Duplicate string key in map when lower casing");
            }
            hashMap.put(string.toLowerCase(), map.get(string));
        }
        return hashMap;
    }

    public static String collapseWhitespace(String string) {
        return StringUtil.collapse(string, WHITE_SPACES, " ");
    }

    public static String collapse(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                if (bl) continue;
                bl = true;
                stringBuilder.append(string3);
                continue;
            }
            bl = false;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String stream2String(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        StringWriter stringWriter = new StringWriter();
        int n2 = 0;
        int n3 = 0;
        do {
            stringWriter.write(new String(byArray, 0, n3));
            n3 = inputStream.read(byArray, 0, byArray.length);
        } while ((-1 == n || (n2 += n3) < n) && n3 != -1);
        return stringWriter.toString();
    }

    public static String[] parseDelimitedList(String string, char c) {
        String string2 = EMPTY_STRING + c;
        StringTokenizer stringTokenizer = new StringTokenizer(string + string2 + " ", string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = EMPTY_STRING;
        String string4 = EMPTY_STRING;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string3 != null) {
                if (string5.equals(string2)) {
                    string4 = string4 + string3;
                    if (string3.equals(string2)) {
                        string5 = null;
                    }
                } else {
                    if (!string4.equals(EMPTY_STRING)) {
                        arrayList.add(string4);
                    }
                    string4 = EMPTY_STRING;
                }
            }
            string3 = string5;
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean isEmpty(String string) {
        return StringUtil.makeSafe(string).length() == 0;
    }

    public static boolean isEmptyOrWhitespace(String string) {
        string = StringUtil.makeSafe(string);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String makeSafe(String string) {
        return string == null ? EMPTY_STRING : string;
    }

    public static String toNullIfEmpty(String string) {
        return StringUtil.isEmpty(string) ? null : string;
    }

    public static String toNullIfEmptyOrWhitespace(String string) {
        return StringUtil.isEmptyOrWhitespace(string) ? null : string;
    }

    public static String arrayMap2String(Map<String, String[]> map, String string, String string2) {
        Set<Map.Entry<String, String[]>> set = map.entrySet();
        Iterator<Map.Entry<String, String[]>> iterator = set.iterator();
        StringWriter stringWriter = new StringWriter();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String string3 = entry.getKey();
            String[] stringArray = entry.getValue();
            for (int i = 0; i < stringArray.length; ++i) {
                stringWriter.write(entry.getKey() + string + stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringWriter.write(string2);
            }
            if (!iterator.hasNext()) continue;
            stringWriter.write(string2);
        }
        return stringWriter.toString();
    }

    public static boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    public static String lastToken(String string, String string2) {
        String[] stringArray = StringUtil.split(string, string2);
        return stringArray.length == 0 ? EMPTY_STRING : stringArray[stringArray.length - 1];
    }

    public static boolean allAscii(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if ((string.charAt(i) & 0xFF80) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCharRef(String string) {
        return characterReferencePattern.matcher(string).find();
    }

    public static boolean isHebrew(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!StringUtil.isHebrew(string.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isHebrew(int n) {
        return Character.UnicodeBlock.HEBREW.equals(Character.UnicodeBlock.of(n));
    }

    public static boolean isCjk(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!StringUtil.isCjk(string.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isCjk(char c) {
        return StringUtil.isCjk((int)c);
    }

    public static boolean isCjk(int n) {
        if ((n & 0xFFFFFF00) == 0) {
            return false;
        }
        return CJK_BLOCKS.contains(Character.UnicodeBlock.of(n));
    }

    public static String unicodeEscape(String string) {
        if (StringUtil.allAscii(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u");
            String string2 = Integer.toHexString(c);
            int n2 = 4 - string2.length();
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static int displayWidth(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n += StringUtil.displayWidth(string.charAt(i));
        }
        return n;
    }

    public static int displayWidth(char c) {
        if (c <= '\u04f9' || c == '\u05be' || c >= '\u05d0' && c <= '\u05ea' || c == '\u05f3' || c == '\u05f4' || c >= '\u0e00' && c <= '\u0e7f' || c >= '\u1e00' && c <= '\u20af' || c >= '\u2100' && c <= '\u213a' || c >= '\uff61' && c <= '\uffdc') {
            return 1;
        }
        return 2;
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < fArray.length; ++i) {
            stringBuilder.append(fArray[i]);
            if (i == fArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuilder.append(lArray[i]);
            if (i == lArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("'").append(stringArray[i]).append("'");
            if (i == stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(String string) {
        if (string == null) {
            return "NULL";
        }
        return new StringBuilder(string.length() + 2).append("'").append(string).append("'").toString();
    }

    public static String toString(int[][] nArray) {
        if (nArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append("[");
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuilder.append(nArray[i][j]);
                if (j == nArray[i].length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            if (i == nArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(long[][] lArray) {
        if (lArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuilder.append("[");
            for (int j = 0; j < lArray[i].length; ++j) {
                stringBuilder.append(lArray[i][j]);
                if (j == lArray[i].length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            if (i == lArray.length - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "NULL";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].toString());
            if (i == objectArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static InputStream toUTF8InputStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
        return byteArrayInputStream;
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[4096];
        while (-1 != (n = inputStream.read(byArray, 0, byArray.length))) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String bytesToLatin1(byte[] byArray) {
        return StringUtil.bytesToEncoding(byArray, "ISO-8859-1");
    }

    public static String bytesToHexString(byte[] byArray) {
        return StringUtil.bytesToHexString(byArray, null);
    }

    public static String bytesToHexString(byte[] byArray, Character c) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * (c == null ? 2 : 3));
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] >>> 4 & 0xF;
            int n2 = byArray[i] & 0xF;
            if (i > 0 && c != null) {
                stringBuffer.append(c.charValue());
            }
            stringBuffer.append(hexChars[n]);
            stringBuffer.append(hexChars[n2]);
        }
        return stringBuffer.toString();
    }

    public static byte[] latin1ToBytes(String string) {
        return StringUtil.encodingToBytes(string, "ISO-8859-1");
    }

    public static String bytesToUtf8(byte[] byArray) {
        return StringUtil.bytesToEncoding(byArray, "UTF8");
    }

    public static byte[] utf8ToBytes(String string) {
        return StringUtil.encodingToBytes(string, "UTF8");
    }

    private static String bytesToEncoding(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(string + " not supported! Original exception: " + unsupportedEncodingException);
        }
    }

    public static byte[] encodingToBytes(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(string2 + " not supported! Original exception: " + unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> bytesToStringList(byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (byArray == null) {
            return arrayList;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        try {
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList;
    }

    public static String toUpperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String expandShardNames(String string) throws IllegalArgumentException, IllegalStateException {
        Matcher matcher = dbSpecPattern.matcher(string);
        if (matcher.find()) {
            try {
                String string2 = string.substring(matcher.start(1), matcher.end(1));
                int n = Integer.parseInt(string.substring(matcher.start(2), matcher.end(2)));
                int n2 = Integer.parseInt(string.substring(matcher.start(3), matcher.end(3)));
                String string3 = string.substring(matcher.start(4), matcher.end(4));
                if (n > n2) {
                    throw new IllegalArgumentException("Maximum shard must be greater than or equal to the minimum shard");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = n; i <= n2; ++i) {
                    stringBuilder.append(string2).append(i).append(string3);
                    if (i == n2) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Malformed DB specification component: " + string);
            }
        }
        return string;
    }

    public static String repeat(String string, int n) {
        if (n < 1) {
            return EMPTY_STRING;
        }
        if (n == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n * string.length());
        while (n > 0) {
            stringBuilder.append(string);
            --n;
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        char c;
        if (string.length() == 0) {
            return string;
        }
        char c2 = string.charAt(0);
        return c2 == (c = Character.toUpperCase(c2)) ? string : c + string.substring(1);
    }

    static {
        escapeStrings.put("&nbsp;", new Character('\u00a0'));
        escapeStrings.put("&iexcl;", new Character('\u00a1'));
        escapeStrings.put("&cent;", new Character('\u00a2'));
        escapeStrings.put("&pound;", new Character('\u00a3'));
        escapeStrings.put("&curren;", new Character('\u00a4'));
        escapeStrings.put("&yen;", new Character('\u00a5'));
        escapeStrings.put("&brvbar;", new Character('\u00a6'));
        escapeStrings.put("&sect;", new Character('\u00a7'));
        escapeStrings.put("&uml;", new Character('\u00a8'));
        escapeStrings.put("&copy;", new Character('\u00a9'));
        escapeStrings.put("&ordf;", new Character('\u00aa'));
        escapeStrings.put("&laquo;", new Character('\u00ab'));
        escapeStrings.put("&not;", new Character('\u00ac'));
        escapeStrings.put("&shy;", new Character('\u00ad'));
        escapeStrings.put("&reg;", new Character('\u00ae'));
        escapeStrings.put("&macr;", new Character('\u00af'));
        escapeStrings.put("&deg;", new Character('\u00b0'));
        escapeStrings.put("&plusmn;", new Character('\u00b1'));
        escapeStrings.put("&sup2;", new Character('\u00b2'));
        escapeStrings.put("&sup3;", new Character('\u00b3'));
        escapeStrings.put("&acute;", new Character('\u00b4'));
        escapeStrings.put("&micro;", new Character('\u00b5'));
        escapeStrings.put("&para;", new Character('\u00b6'));
        escapeStrings.put("&middot;", new Character('\u00b7'));
        escapeStrings.put("&cedil;", new Character('\u00b8'));
        escapeStrings.put("&sup1;", new Character('\u00b9'));
        escapeStrings.put("&ordm;", new Character('\u00ba'));
        escapeStrings.put("&raquo;", new Character('\u00bb'));
        escapeStrings.put("&frac14;", new Character('\u00bc'));
        escapeStrings.put("&frac12;", new Character('\u00bd'));
        escapeStrings.put("&frac34;", new Character('\u00be'));
        escapeStrings.put("&iquest;", new Character('\u00bf'));
        escapeStrings.put("&Agrave;", new Character('\u00c0'));
        escapeStrings.put("&Aacute;", new Character('\u00c1'));
        escapeStrings.put("&Acirc;", new Character('\u00c2'));
        escapeStrings.put("&Atilde;", new Character('\u00c3'));
        escapeStrings.put("&Auml;", new Character('\u00c4'));
        escapeStrings.put("&Aring;", new Character('\u00c5'));
        escapeStrings.put("&AElig;", new Character('\u00c6'));
        escapeStrings.put("&Ccedil;", new Character('\u00c7'));
        escapeStrings.put("&Egrave;", new Character('\u00c8'));
        escapeStrings.put("&Eacute;", new Character('\u00c9'));
        escapeStrings.put("&Ecirc;", new Character('\u00ca'));
        escapeStrings.put("&Euml;", new Character('\u00cb'));
        escapeStrings.put("&Igrave;", new Character('\u00cc'));
        escapeStrings.put("&Iacute;", new Character('\u00cd'));
        escapeStrings.put("&Icirc;", new Character('\u00ce'));
        escapeStrings.put("&Iuml;", new Character('\u00cf'));
        escapeStrings.put("&ETH;", new Character('\u00d0'));
        escapeStrings.put("&Ntilde;", new Character('\u00d1'));
        escapeStrings.put("&Ograve;", new Character('\u00d2'));
        escapeStrings.put("&Oacute;", new Character('\u00d3'));
        escapeStrings.put("&Ocirc;", new Character('\u00d4'));
        escapeStrings.put("&Otilde;", new Character('\u00d5'));
        escapeStrings.put("&Ouml;", new Character('\u00d6'));
        escapeStrings.put("&times;", new Character('\u00d7'));
        escapeStrings.put("&Oslash;", new Character('\u00d8'));
        escapeStrings.put("&Ugrave;", new Character('\u00d9'));
        escapeStrings.put("&Uacute;", new Character('\u00da'));
        escapeStrings.put("&Ucirc;", new Character('\u00db'));
        escapeStrings.put("&Uuml;", new Character('\u00dc'));
        escapeStrings.put("&Yacute;", new Character('\u00dd'));
        escapeStrings.put("&THORN;", new Character('\u00de'));
        escapeStrings.put("&szlig;", new Character('\u00df'));
        escapeStrings.put("&agrave;", new Character('\u00e0'));
        escapeStrings.put("&aacute;", new Character('\u00e1'));
        escapeStrings.put("&acirc;", new Character('\u00e2'));
        escapeStrings.put("&atilde;", new Character('\u00e3'));
        escapeStrings.put("&auml;", new Character('\u00e4'));
        escapeStrings.put("&aring;", new Character('\u00e5'));
        escapeStrings.put("&aelig;", new Character('\u00e6'));
        escapeStrings.put("&ccedil;", new Character('\u00e7'));
        escapeStrings.put("&egrave;", new Character('\u00e8'));
        escapeStrings.put("&eacute;", new Character('\u00e9'));
        escapeStrings.put("&ecirc;", new Character('\u00ea'));
        escapeStrings.put("&euml;", new Character('\u00eb'));
        escapeStrings.put("&igrave;", new Character('\u00ec'));
        escapeStrings.put("&iacute;", new Character('\u00ed'));
        escapeStrings.put("&icirc;", new Character('\u00ee'));
        escapeStrings.put("&iuml;", new Character('\u00ef'));
        escapeStrings.put("&eth;", new Character('\u00f0'));
        escapeStrings.put("&ntilde;", new Character('\u00f1'));
        escapeStrings.put("&ograve;", new Character('\u00f2'));
        escapeStrings.put("&oacute;", new Character('\u00f3'));
        escapeStrings.put("&ocirc;", new Character('\u00f4'));
        escapeStrings.put("&otilde;", new Character('\u00f5'));
        escapeStrings.put("&ouml;", new Character('\u00f6'));
        escapeStrings.put("&divide;", new Character('\u00f7'));
        escapeStrings.put("&oslash;", new Character('\u00f8'));
        escapeStrings.put("&ugrave;", new Character('\u00f9'));
        escapeStrings.put("&uacute;", new Character('\u00fa'));
        escapeStrings.put("&ucirc;", new Character('\u00fb'));
        escapeStrings.put("&uuml;", new Character('\u00fc'));
        escapeStrings.put("&yacute;", new Character('\u00fd'));
        escapeStrings.put("&thorn;", new Character('\u00fe'));
        escapeStrings.put("&yuml;", new Character('\u00ff'));
        escapeStrings.put("&fnof;", new Character('\u0192'));
        escapeStrings.put("&Alpha;", new Character('\u0391'));
        escapeStrings.put("&Beta;", new Character('\u0392'));
        escapeStrings.put("&Gamma;", new Character('\u0393'));
        escapeStrings.put("&Delta;", new Character('\u0394'));
        escapeStrings.put("&Epsilon;", new Character('\u0395'));
        escapeStrings.put("&Zeta;", new Character('\u0396'));
        escapeStrings.put("&Eta;", new Character('\u0397'));
        escapeStrings.put("&Theta;", new Character('\u0398'));
        escapeStrings.put("&Iota;", new Character('\u0399'));
        escapeStrings.put("&Kappa;", new Character('\u039a'));
        escapeStrings.put("&Lambda;", new Character('\u039b'));
        escapeStrings.put("&Mu;", new Character('\u039c'));
        escapeStrings.put("&Nu;", new Character('\u039d'));
        escapeStrings.put("&Xi;", new Character('\u039e'));
        escapeStrings.put("&Omicron;", new Character('\u039f'));
        escapeStrings.put("&Pi;", new Character('\u03a0'));
        escapeStrings.put("&Rho;", new Character('\u03a1'));
        escapeStrings.put("&Sigma;", new Character('\u03a3'));
        escapeStrings.put("&Tau;", new Character('\u03a4'));
        escapeStrings.put("&Upsilon;", new Character('\u03a5'));
        escapeStrings.put("&Phi;", new Character('\u03a6'));
        escapeStrings.put("&Chi;", new Character('\u03a7'));
        escapeStrings.put("&Psi;", new Character('\u03a8'));
        escapeStrings.put("&Omega;", new Character('\u03a9'));
        escapeStrings.put("&alpha;", new Character('\u03b1'));
        escapeStrings.put("&beta;", new Character('\u03b2'));
        escapeStrings.put("&gamma;", new Character('\u03b3'));
        escapeStrings.put("&delta;", new Character('\u03b4'));
        escapeStrings.put("&epsilon;", new Character('\u03b5'));
        escapeStrings.put("&zeta;", new Character('\u03b6'));
        escapeStrings.put("&eta;", new Character('\u03b7'));
        escapeStrings.put("&theta;", new Character('\u03b8'));
        escapeStrings.put("&iota;", new Character('\u03b9'));
        escapeStrings.put("&kappa;", new Character('\u03ba'));
        escapeStrings.put("&lambda;", new Character('\u03bb'));
        escapeStrings.put("&mu;", new Character('\u03bc'));
        escapeStrings.put("&nu;", new Character('\u03bd'));
        escapeStrings.put("&xi;", new Character('\u03be'));
        escapeStrings.put("&omicron;", new Character('\u03bf'));
        escapeStrings.put("&pi;", new Character('\u03c0'));
        escapeStrings.put("&rho;", new Character('\u03c1'));
        escapeStrings.put("&sigmaf;", new Character('\u03c2'));
        escapeStrings.put("&sigma;", new Character('\u03c3'));
        escapeStrings.put("&tau;", new Character('\u03c4'));
        escapeStrings.put("&upsilon;", new Character('\u03c5'));
        escapeStrings.put("&phi;", new Character('\u03c6'));
        escapeStrings.put("&chi;", new Character('\u03c7'));
        escapeStrings.put("&psi;", new Character('\u03c8'));
        escapeStrings.put("&omega;", new Character('\u03c9'));
        escapeStrings.put("&thetasym;", new Character('\u03d1'));
        escapeStrings.put("&upsih;", new Character('\u03d2'));
        escapeStrings.put("&piv;", new Character('\u03d6'));
        escapeStrings.put("&bull;", new Character('\u2022'));
        escapeStrings.put("&hellip;", new Character('\u2026'));
        escapeStrings.put("&prime;", new Character('\u2032'));
        escapeStrings.put("&Prime;", new Character('\u2033'));
        escapeStrings.put("&oline;", new Character('\u203e'));
        escapeStrings.put("&frasl;", new Character('\u2044'));
        escapeStrings.put("&weierp;", new Character('\u2118'));
        escapeStrings.put("&image;", new Character('\u2111'));
        escapeStrings.put("&real;", new Character('\u211c'));
        escapeStrings.put("&trade;", new Character('\u2122'));
        escapeStrings.put("&alefsym;", new Character('\u2135'));
        escapeStrings.put("&larr;", new Character('\u2190'));
        escapeStrings.put("&uarr;", new Character('\u2191'));
        escapeStrings.put("&rarr;", new Character('\u2192'));
        escapeStrings.put("&darr;", new Character('\u2193'));
        escapeStrings.put("&harr;", new Character('\u2194'));
        escapeStrings.put("&crarr;", new Character('\u21b5'));
        escapeStrings.put("&lArr;", new Character('\u21d0'));
        escapeStrings.put("&uArr;", new Character('\u21d1'));
        escapeStrings.put("&rArr;", new Character('\u21d2'));
        escapeStrings.put("&dArr;", new Character('\u21d3'));
        escapeStrings.put("&hArr;", new Character('\u21d4'));
        escapeStrings.put("&forall;", new Character('\u2200'));
        escapeStrings.put("&part;", new Character('\u2202'));
        escapeStrings.put("&exist;", new Character('\u2203'));
        escapeStrings.put("&empty;", new Character('\u2205'));
        escapeStrings.put("&nabla;", new Character('\u2207'));
        escapeStrings.put("&isin;", new Character('\u2208'));
        escapeStrings.put("&notin;", new Character('\u2209'));
        escapeStrings.put("&ni;", new Character('\u220b'));
        escapeStrings.put("&prod;", new Character('\u220f'));
        escapeStrings.put("&sum;", new Character('\u2211'));
        escapeStrings.put("&minus;", new Character('\u2212'));
        escapeStrings.put("&lowast;", new Character('\u2217'));
        escapeStrings.put("&radic;", new Character('\u221a'));
        escapeStrings.put("&prop;", new Character('\u221d'));
        escapeStrings.put("&infin;", new Character('\u221e'));
        escapeStrings.put("&ang;", new Character('\u2220'));
        escapeStrings.put("&and;", new Character('\u2227'));
        escapeStrings.put("&or;", new Character('\u2228'));
        escapeStrings.put("&cap;", new Character('\u2229'));
        escapeStrings.put("&cup;", new Character('\u222a'));
        escapeStrings.put("&int;", new Character('\u222b'));
        escapeStrings.put("&there4;", new Character('\u2234'));
        escapeStrings.put("&sim;", new Character('\u223c'));
        escapeStrings.put("&cong;", new Character('\u2245'));
        escapeStrings.put("&asymp;", new Character('\u2248'));
        escapeStrings.put("&ne;", new Character('\u2260'));
        escapeStrings.put("&equiv;", new Character('\u2261'));
        escapeStrings.put("&le;", new Character('\u2264'));
        escapeStrings.put("&ge;", new Character('\u2265'));
        escapeStrings.put("&sub;", new Character('\u2282'));
        escapeStrings.put("&sup;", new Character('\u2283'));
        escapeStrings.put("&nsub;", new Character('\u2284'));
        escapeStrings.put("&sube;", new Character('\u2286'));
        escapeStrings.put("&supe;", new Character('\u2287'));
        escapeStrings.put("&oplus;", new Character('\u2295'));
        escapeStrings.put("&otimes;", new Character('\u2297'));
        escapeStrings.put("&perp;", new Character('\u22a5'));
        escapeStrings.put("&sdot;", new Character('\u22c5'));
        escapeStrings.put("&lceil;", new Character('\u2308'));
        escapeStrings.put("&rceil;", new Character('\u2309'));
        escapeStrings.put("&lfloor;", new Character('\u230a'));
        escapeStrings.put("&rfloor;", new Character('\u230b'));
        escapeStrings.put("&lang;", new Character('\u2329'));
        escapeStrings.put("&rang;", new Character('\u232a'));
        escapeStrings.put("&loz;", new Character('\u25ca'));
        escapeStrings.put("&spades;", new Character('\u2660'));
        escapeStrings.put("&clubs;", new Character('\u2663'));
        escapeStrings.put("&hearts;", new Character('\u2665'));
        escapeStrings.put("&diams;", new Character('\u2666'));
        escapeStrings.put("&quot;", new Character('\"'));
        escapeStrings.put("&amp;", new Character('&'));
        escapeStrings.put("&lt;", new Character('<'));
        escapeStrings.put("&gt;", new Character('>'));
        escapeStrings.put("&OElig;", new Character('\u0152'));
        escapeStrings.put("&oelig;", new Character('\u0153'));
        escapeStrings.put("&Scaron;", new Character('\u0160'));
        escapeStrings.put("&scaron;", new Character('\u0161'));
        escapeStrings.put("&Yuml;", new Character('\u0178'));
        escapeStrings.put("&circ;", new Character('\u02c6'));
        escapeStrings.put("&tilde;", new Character('\u02dc'));
        escapeStrings.put("&ensp;", new Character('\u2002'));
        escapeStrings.put("&emsp;", new Character('\u2003'));
        escapeStrings.put("&thinsp;", new Character('\u2009'));
        escapeStrings.put("&zwnj;", new Character('\u200c'));
        escapeStrings.put("&zwj;", new Character('\u200d'));
        escapeStrings.put("&lrm;", new Character('\u200e'));
        escapeStrings.put("&rlm;", new Character('\u200f'));
        escapeStrings.put("&ndash;", new Character('\u2013'));
        escapeStrings.put("&mdash;", new Character('\u2014'));
        escapeStrings.put("&lsquo;", new Character('\u2018'));
        escapeStrings.put("&rsquo;", new Character('\u2019'));
        escapeStrings.put("&sbquo;", new Character('\u201a'));
        escapeStrings.put("&ldquo;", new Character('\u201c'));
        escapeStrings.put("&rdquo;", new Character('\u201d'));
        escapeStrings.put("&bdquo;", new Character('\u201e'));
        escapeStrings.put("&dagger;", new Character('\u2020'));
        escapeStrings.put("&Dagger;", new Character('\u2021'));
        escapeStrings.put("&permil;", new Character('\u2030'));
        escapeStrings.put("&lsaquo;", new Character('\u2039'));
        escapeStrings.put("&rsaquo;", new Character('\u203a'));
        escapeStrings.put("&euro;", new Character('\u20ac'));
        UNSAFE_TAGS = new String[]{"script", "style", "object", "applet", "!--"};
        HashSet<Character.UnicodeBlock> hashSet = new HashSet<Character.UnicodeBlock>();
        hashSet.add(Character.UnicodeBlock.HANGUL_JAMO);
        hashSet.add(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT);
        hashSet.add(Character.UnicodeBlock.KANGXI_RADICALS);
        hashSet.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
        hashSet.add(Character.UnicodeBlock.HIRAGANA);
        hashSet.add(Character.UnicodeBlock.KATAKANA);
        hashSet.add(Character.UnicodeBlock.BOPOMOFO);
        hashSet.add(Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO);
        hashSet.add(Character.UnicodeBlock.KANBUN);
        hashSet.add(Character.UnicodeBlock.BOPOMOFO_EXTENDED);
        hashSet.add(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS);
        hashSet.add(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS);
        hashSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
        hashSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        hashSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        hashSet.add(Character.UnicodeBlock.HANGUL_SYLLABLES);
        hashSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        hashSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS);
        hashSet.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
        hashSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
        hashSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
        CJK_BLOCKS = Collections.unmodifiableSet(hashSet);
        hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

