/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public abstract class ValueConstruct
implements Extension {
    protected final XmlWriter.Namespace namespace;
    protected final String localName;
    protected final String attrName;
    private String value;
    private boolean isImmutable;

    protected ValueConstruct(XmlWriter.Namespace namespace, String string, String string2) {
        this(namespace, string, string2, null);
    }

    protected ValueConstruct(XmlWriter.Namespace namespace, String string, String string2, String string3) {
        this.namespace = namespace;
        this.localName = string;
        this.attrName = string2;
        if (string3 != null) {
            this.value = string3;
            this.isImmutable = true;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.isImmutable) {
            throw new IllegalStateException(this.localName + " instance is read only");
        }
        this.value = string;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        if (this.value != null) {
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            String string = null;
            if (this.attrName != null) {
                arrayList.add(new XmlWriter.Attribute(this.attrName, this.value));
            } else {
                string = this.value;
            }
            xmlWriter.simpleElement(this.namespace, this.localName, arrayList, string);
        }
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValueConstruct valueConstruct = (ValueConstruct)object;
        return this.value != null ? this.value.equals(valueConstruct.value) : valueConstruct.value == null;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getClass().hashCode();
        if (this.value != null) {
            n = 37 * n + this.value.hashCode();
        }
        return n;
    }

    private class Handler
    extends XmlParser.ElementHandler {
        public Handler() {
            if (ValueConstruct.this.isImmutable) {
                throw new IllegalStateException("Cannot parse into immutable instance");
            }
            ValueConstruct.this.value = null;
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("")) {
                if (string2.equals(ValueConstruct.this.attrName)) {
                    if (ValueConstruct.this.getValue() != null) {
                        throw new ParseException("Attribute '" + ValueConstruct.this.attrName + "' appears multiple times");
                    }
                    try {
                        ValueConstruct.this.setValue(string3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
                    }
                } else {
                    throw new ParseException("Invalid attribute: " + string2);
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (ValueConstruct.this.attrName != null) {
                if (ValueConstruct.this.getValue() == null) {
                    throw new ParseException("Missing attribute: " + ValueConstruct.this.attrName);
                }
            } else {
                if (this.value == null) {
                    throw new ParseException("Missing element value");
                }
                ValueConstruct.this.setValue(this.value);
            }
        }
    }
}

