/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.Service;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Entry;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.Rfc3339Handler;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEntry<E extends BaseEntry>
extends ExtensionPoint
implements Kind.Adaptable,
Kind.Adaptor {
    protected EntryState state;
    private static final Collection<XmlWriter.Namespace> namespaceDeclsAtom = new Vector<XmlWriter.Namespace>(1);
    private static final Collection<XmlWriter.Namespace> namespaceDeclsRss = new Vector<XmlWriter.Namespace>(1);

    protected BaseEntry() {
        this.state = new EntryState();
    }

    protected BaseEntry(BaseEntry baseEntry) {
        super(baseEntry);
        this.state = baseEntry.state;
    }

    public String getId() {
        return this.state.id;
    }

    public void setId(String string) {
        if (string != null && string.charAt(0) == '-') {
            throw new IllegalArgumentException("Entry ID must not start with a '-'.");
        }
        this.state.id = string;
    }

    public String getVersionId() {
        return this.state.versionId;
    }

    public void setVersionId(String string) {
        this.state.versionId = string;
    }

    public DateTime getPublished() {
        return this.state.published;
    }

    public void setPublished(DateTime dateTime) {
        if (dateTime != null && dateTime.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.published must have a timezone.");
        }
        this.state.published = dateTime;
    }

    public DateTime getUpdated() {
        return this.state.updated;
    }

    public void setUpdated(DateTime dateTime) {
        if (dateTime != null && dateTime.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.updated must have a timezone.");
        }
        this.state.updated = dateTime;
    }

    public Set<Category> getCategories() {
        return this.state.categories;
    }

    public TextConstruct getTitle() {
        return this.state.title;
    }

    public void setTitle(TextConstruct textConstruct) {
        this.state.title = textConstruct;
    }

    public TextConstruct getSummary() {
        return this.state.summary;
    }

    public void setSummary(TextConstruct textConstruct) {
        this.state.summary = textConstruct;
    }

    public TextConstruct getRights() {
        return this.state.rights;
    }

    public void setRights(TextConstruct textConstruct) {
        this.state.rights = textConstruct;
    }

    public Content getContent() {
        return this.state.content;
    }

    public void setContent(Content content) {
        this.state.content = content;
    }

    public void setContent(TextConstruct textConstruct) {
        this.state.content = new TextContent(textConstruct);
    }

    public List<Link> getLinks() {
        return this.state.links;
    }

    public List<Person> getAuthors() {
        return this.state.authors;
    }

    public List<Person> getContributors() {
        return this.state.contributors;
    }

    public Source getSource() {
        return this.state.source;
    }

    public void setSource(Source source) {
        this.state.source = source;
    }

    public void setDraft(Boolean bl) {
        this.state.isDraft = bl;
    }

    public boolean isDraft() {
        return this.state.isDraft != null ? this.state.isDraft : false;
    }

    public void setService(Service service) {
        this.state.service = service;
    }

    public Service getService() {
        return this.state.service;
    }

    public boolean getCanEdit() {
        return this.state.canEdit;
    }

    public void setCanEdit(boolean bl) {
        this.state.canEdit = bl;
    }

    @Override
    public void addAdaptor(Kind.Adaptor adaptor) {
        this.state.adaptable.addAdaptor(adaptor);
    }

    @Override
    public Collection<Kind.Adaptor> getAdaptors() {
        return this.state.adaptable.getAdaptors();
    }

    @Override
    public <E extends Kind.Adaptor> E getAdaptor(Class<E> clazz) {
        return this.state.adaptable.getAdaptor(clazz);
    }

    public Link getLink(String string, String string2) {
        for (Link link : this.state.links) {
            String string3 = link.getRel();
            String string4 = link.getType();
            if (string != null && (string3 == null || !string3.equals(string)) || string2 != null && (string4 == null || !string4.equals(string2))) continue;
            return link;
        }
        return null;
    }

    public void addHtmlLink(String string, String string2, String string3) {
        Link link = new Link();
        link.setRel("alternate");
        link.setType("text/html");
        link.setHref(string);
        if (string2 != null) {
            link.setHrefLang(string2);
        }
        if (string3 != null) {
            link.setTitle(string3);
        }
        this.state.links.add(link);
    }

    public Link getSelfLink() {
        Link link = this.getLink("self", "application/atom+xml");
        return link;
    }

    public Link getEditLink() {
        Link link = this.getLink("edit", "application/atom+xml");
        return link;
    }

    public Link getHtmlLink() {
        Link link = this.getLink("alternate", "text/html");
        return link;
    }

    public E getSelf() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException("Entry is not associated with a GData service");
        }
        Link link = this.getSelfLink();
        if (link == null) {
            throw new UnsupportedOperationException("Entry cannot be retrieved");
        }
        URL uRL = new URL(link.getHref());
        try {
            return (E)this.state.service.getEntry(uRL, this.getClass(), this.state.updated);
        }
        catch (NotModifiedException notModifiedException) {
            return (E)this;
        }
    }

    public E update() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException("Entry is not associated with a GData service");
        }
        Link link = this.getEditLink();
        if (link == null) {
            throw new UnsupportedOperationException("Entry cannot be updated");
        }
        URL uRL = new URL(link.getHref());
        return (E)this.state.service.update(uRL, this);
    }

    public void delete() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException("Entry is not associated with a GData service");
        }
        Link link = this.getEditLink();
        if (link == null) {
            throw new UnsupportedOperationException("Entry cannot be deleted");
        }
        URL uRL = new URL(link.getHref());
        this.state.service.delete(uRL);
    }

    public void generateAtom(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        Vector<XmlWriter.Namespace> vector = new Vector<XmlWriter.Namespace>(namespaceDeclsAtom);
        vector.addAll(extensionProfile.getNamespaceDecls());
        this.generateStartElement(xmlWriter, Namespaces.atomNs, "entry", null, vector);
        if (this.state.id != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "id", null, this.state.id);
        }
        if (this.state.published != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "published", null, this.state.published.toString());
        }
        if (this.state.updated != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "updated", null, this.state.updated.toString());
        }
        if (this.isDraft()) {
            xmlWriter.startElement(Namespaces.atomPubNs, "control", null, null);
            xmlWriter.simpleElement(Namespaces.atomPubNs, "draft", null, "yes");
            xmlWriter.endElement();
        }
        xmlWriter.startRepeatingElement();
        for (Category object : this.state.categories) {
            object.generateAtom(xmlWriter);
        }
        xmlWriter.endRepeatingElement();
        if (this.state.title != null) {
            this.state.title.generateAtom(xmlWriter, "title");
        }
        if (this.state.summary != null) {
            this.state.summary.generateAtom(xmlWriter, "summary");
        }
        if (this.state.rights != null) {
            this.state.rights.generateAtom(xmlWriter, "rights");
        }
        if (this.state.content != null) {
            this.state.content.generateAtom(xmlWriter);
        }
        xmlWriter.startRepeatingElement();
        for (Link link : this.state.links) {
            link.generateAtom(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.state.authors) {
            person.generateAtom(extensionProfile, xmlWriter, "author");
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.state.contributors) {
            person.generateAtom(extensionProfile, xmlWriter, "contributor");
        }
        xmlWriter.endRepeatingElement();
        if (this.state.source != null) {
            this.state.source.generateAtom(xmlWriter, extensionProfile);
        }
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.atomNs, "entry");
    }

    public void generateRss(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        Object object;
        Vector<XmlWriter.Namespace> vector = new Vector<XmlWriter.Namespace>(namespaceDeclsRss);
        vector.addAll(extensionProfile.getNamespaceDecls());
        this.generateStartElement(xmlWriter, Namespaces.rssNs, "item", null, vector);
        if (this.state.id != null) {
            object = new ArrayList<XmlWriter.Attribute>(1);
            object.add(new XmlWriter.Attribute("isPermaLink", "false"));
            xmlWriter.simpleElement(Namespaces.rssNs, "guid", (List<XmlWriter.Attribute>)object, this.state.id);
        }
        object = null;
        if (this.state.content != null) {
            object = this.state.content.getLang();
        }
        if (object == null && this.state.summary != null) {
            object = this.state.summary.getLang();
        }
        if (object == null && this.state.title != null) {
            object = this.state.title.getLang();
        }
        if (object != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "language", null, (String)object);
        }
        if (this.state.published != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "pubDate", null, this.state.published.toStringRfc822());
        }
        if (this.state.updated != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "updated", null, this.state.updated.toString());
        }
        xmlWriter.startRepeatingElement();
        for (Category object2 : this.state.categories) {
            object2.generateRss(xmlWriter);
        }
        xmlWriter.endRepeatingElement();
        if (this.state.title != null) {
            this.state.title.generateRss(xmlWriter, "title", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.state.summary != null) {
            this.state.summary.generateAtom(xmlWriter, "summary");
        }
        if (this.state.content != null) {
            this.state.content.generateRss(xmlWriter);
        }
        xmlWriter.startRepeatingElement();
        for (Link link : this.state.links) {
            link.generateRss(xmlWriter);
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.state.authors) {
            person.generateRss(xmlWriter, "author");
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.startRepeatingElement();
        for (Person person : this.state.contributors) {
            person.generateRss(xmlWriter, "author");
        }
        xmlWriter.endRepeatingElement();
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.rssNs, "item");
    }

    public void parseAtom(ExtensionProfile extensionProfile, InputStream inputStream) throws IOException, ParseException {
        AtomHandler atomHandler = new AtomHandler(extensionProfile);
        new XmlParser().parse(inputStream, (XmlParser.ElementHandler)atomHandler, "http://www.w3.org/2005/Atom", "entry");
    }

    public void parseAtom(ExtensionProfile extensionProfile, Reader reader) throws IOException, ParseException {
        AtomHandler atomHandler = new AtomHandler(extensionProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)atomHandler, "http://www.w3.org/2005/Atom", "entry");
    }

    static {
        namespaceDeclsAtom.add(Namespaces.atomNs);
        namespaceDeclsRss.add(Namespaces.atomNs);
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile extensionProfile) throws IOException {
            super(BaseEntry.this, extensionProfile, Entry.class);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            if (string.equals("http://www.w3.org/2005/Atom")) {
                if (string2.equals("id")) {
                    return new IdHandler();
                }
                if (string2.equals("published")) {
                    return new PublishedHandler();
                }
                if (string2.equals("updated")) {
                    return new UpdatedHandler();
                }
                if (string2.equals("title")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (BaseEntry.this.state.title != null) {
                        throw new ParseException("Duplicate title.");
                    }
                    BaseEntry.this.state.title = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("summary")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (BaseEntry.this.state.summary != null) {
                        throw new ParseException("Duplicate summary.");
                    }
                    BaseEntry.this.state.summary = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("rights")) {
                    TextConstruct.ChildHandlerInfo childHandlerInfo = TextConstruct.getChildHandler(attributes);
                    if (BaseEntry.this.state.rights != null) {
                        throw new ParseException("Duplicate rights.");
                    }
                    BaseEntry.this.state.rights = childHandlerInfo.textConstruct;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("content")) {
                    Content.ChildHandlerInfo childHandlerInfo = Content.getChildHandler(attributes);
                    if (BaseEntry.this.state.content != null) {
                        throw new ParseException("Duplicate content.");
                    }
                    BaseEntry.this.state.content = childHandlerInfo.content;
                    return childHandlerInfo.handler;
                }
                if (string2.equals("category")) {
                    Category category;
                    Category category2 = category = new Category();
                    category2.getClass();
                    return new Category.AtomHandler(category2, this.extProfile, BaseEntry.this.state.categories, BaseEntry.this);
                }
                if (string2.equals("link")) {
                    Link link = new Link();
                    BaseEntry.this.state.links.add(link);
                    Link link2 = link;
                    link2.getClass();
                    return new Link.AtomHandler(link2, this.extProfile);
                }
                if (string2.equals("author")) {
                    Person person = new Person();
                    BaseEntry.this.state.authors.add(person);
                    Person person2 = person;
                    person2.getClass();
                    return new Person.AtomHandler(person2, this.extProfile);
                }
                if (string2.equals("contributor")) {
                    Person person = new Person();
                    BaseEntry.this.state.contributors.add(person);
                    Person person3 = person;
                    person3.getClass();
                    return new Person.AtomHandler(person3, this.extProfile);
                }
                if (string2.equals("source")) {
                    Source source = BaseEntry.this.state.source = new Source();
                    source.getClass();
                    return new Source.SourceHandler(source, this.extProfile);
                }
            } else if (string.equals("http://purl.org/atom/app#")) {
                if (string2.equals("control")) {
                    return new ControlHandler();
                }
            } else {
                return super.getChildHandler(string, string2, attributes);
            }
            return null;
        }

        class DraftHandler
        extends XmlParser.ElementHandler {
            DraftHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseEntry.this.state.isDraft != null) {
                    throw new ParseException("Duplicate draft element");
                }
                if (this.value.equals("yes")) {
                    BaseEntry.this.state.isDraft = true;
                } else if (this.value.equals("no")) {
                    BaseEntry.this.state.isDraft = false;
                } else {
                    throw new ParseException("Invalid value for draft");
                }
            }
        }

        class ControlHandler
        extends XmlParser.ElementHandler {
            ControlHandler() {
            }

            public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
                if (string.equals("http://purl.org/atom/app#")) {
                    if (string2.equals("draft")) {
                        return new DraftHandler();
                    }
                } else {
                    return super.getChildHandler(string, string2, attributes);
                }
                return null;
            }
        }

        class UpdatedHandler
        extends Rfc3339Handler {
            UpdatedHandler() {
            }

            public void processEndElement() throws ParseException {
                super.processEndElement();
                BaseEntry.this.state.updated = this.getDateTime();
            }
        }

        class PublishedHandler
        extends Rfc3339Handler {
            PublishedHandler() {
            }

            public void processEndElement() throws ParseException {
                super.processEndElement();
                BaseEntry.this.state.published = this.getDateTime();
            }
        }

        class IdHandler
        extends XmlParser.ElementHandler {
            IdHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseEntry.this.state.id != null) {
                    throw new ParseException("Duplicate entry ID.");
                }
                if (this.value == null) {
                    throw new ParseException("ID must have a value.");
                }
                BaseEntry.this.state.id = this.value;
            }
        }
    }

    protected static class EntryState {
        public String id;
        public String versionId;
        public DateTime published;
        public DateTime updated;
        public HashSet<Category> categories = new HashSet();
        public TextConstruct title;
        public TextConstruct summary;
        public TextConstruct rights;
        public Content content;
        public LinkedList<Link> links = new LinkedList();
        public LinkedList<Person> authors = new LinkedList();
        public LinkedList<Person> contributors = new LinkedList();
        public Source source;
        public Service service;
        public boolean canEdit = true;
        public Boolean isDraft;
        public Kind.Adaptable adaptable = new Kind.AdaptableHelper();

        protected EntryState() {
        }
    }
}

