/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PMRect;
import org.eclipse.swt.internal.carbon.PMResolution;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    int printSession;
    int printSettings;
    int pageFormat;
    boolean inPage;
    boolean isGCCreated;
    int context;
    int colorspace;
    static final String DRIVER = "Mac";
    static final String PRINTER_DRIVER = "Printer";
    static final String FILE_DRIVER = "File";
    static final String PREVIEW_DRIVER = "Preview";
    static final String FAX_DRIVER = "Fax";

    public static PrinterData[] getPrinterList() {
        PrinterData[] result = null;
        int[] printSession = new int[1];
        OS.PMCreateSession(printSession);
        if (printSession[0] != 0) {
            int[] printerList = new int[1];
            int[] currentIndex = new int[1];
            int[] currentPrinter = new int[1];
            OS.PMSessionCreatePrinterList(printSession[0], printerList, currentIndex, currentPrinter);
            if (printerList[0] != 0) {
                int count = OS.CFArrayGetCount(printerList[0]);
                result = new PrinterData[count];
                int i = 0;
                while (i < count) {
                    String name = Printer.getString(OS.CFArrayGetValueAtIndex(printerList[0], i));
                    result[i] = new PrinterData(DRIVER, name);
                    ++i;
                }
                OS.CFRelease(printerList[0]);
            }
            OS.PMRelease(printSession[0]);
        }
        return result == null ? new PrinterData[]{} : result;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData result = null;
        int[] printSession = new int[1];
        OS.PMCreateSession(printSession);
        if (printSession[0] != 0) {
            String name = Printer.getCurrentPrinterName(printSession[0]);
            if (name != null) {
                result = new PrinterData(DRIVER, name);
            }
            OS.PMRelease(printSession[0]);
        }
        return result;
    }

    static String getCurrentPrinterName(int printSession) {
        String result = null;
        int[] printerList = new int[1];
        int[] currentIndex = new int[1];
        int[] currentPrinter = new int[1];
        OS.PMSessionCreatePrinterList(printSession, printerList, currentIndex, currentPrinter);
        if (printerList[0] != 0) {
            int count = OS.CFArrayGetCount(printerList[0]);
            if (currentIndex[0] >= 0 && currentIndex[0] < count) {
                result = Printer.getString(OS.CFArrayGetValueAtIndex(printerList[0], currentIndex[0]));
            }
            OS.CFRelease(printerList[0]);
        }
        return result;
    }

    static String getString(int ptr) {
        int length = OS.CFStringGetLength(ptr);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(ptr, range, buffer);
        return new String(buffer);
    }

    static int packData(int handle, byte[] buffer, int offset) {
        int length = OS.GetHandleSize(handle);
        buffer[offset++] = (byte)((length & 0xFF) >> 0);
        buffer[offset++] = (byte)((length & 0xFF00) >> 8);
        buffer[offset++] = (byte)((length & 0xFF0000) >> 16);
        buffer[offset++] = (byte)((length & 0xFF000000) >> 24);
        int[] ptr = new int[1];
        OS.HLock(handle);
        OS.memcpy(ptr, handle, 4);
        byte[] buffer1 = new byte[length];
        OS.memcpy(buffer1, ptr[0], length);
        OS.HUnlock(handle);
        System.arraycopy(buffer1, 0, buffer, offset, length);
        return offset + length;
    }

    static int unpackData(int[] handle, byte[] buffer, int offset) {
        int length = (buffer[offset++] & 0xFF) << 0 | (buffer[offset++] & 0xFF) << 8 | (buffer[offset++] & 0xFF) << 16 | (buffer[offset++] & 0xFF) << 24;
        handle[0] = OS.NewHandle(length);
        if (handle[0] == 0) {
            SWT.error(2);
        }
        int[] ptr = new int[1];
        OS.HLock(handle[0]);
        OS.memcpy(ptr, handle[0], 4);
        byte[] buffer1 = new byte[length];
        System.arraycopy(buffer, offset, buffer1, 0, length);
        OS.memcpy(ptr[0], buffer1, length);
        OS.HUnlock(handle[0]);
        return offset + length;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        PMRect pageRect = new PMRect();
        PMRect paperRect = new PMRect();
        OS.PMGetAdjustedPageRect(this.pageFormat, pageRect);
        OS.PMGetAdjustedPaperRect(this.pageFormat, paperRect);
        return new Rectangle(x + (int)paperRect.left, y + (int)paperRect.top, width + (int)(paperRect.right - pageRect.right), height + (int)(paperRect.bottom - pageRect.bottom));
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        int[] buffer = new int[1];
        if (OS.PMCreateSession(buffer) != 0) {
            SWT.error(2);
        }
        this.printSession = buffer[0];
        if (this.printSession == 0) {
            SWT.error(2);
        }
        if (this.data.otherData != null) {
            int offset = 0;
            byte[] otherData = this.data.otherData;
            offset = Printer.unpackData(buffer, otherData, offset);
            int flatSettings = buffer[0];
            offset = Printer.unpackData(buffer, otherData, offset);
            int flatFormat = buffer[0];
            if (OS.PMUnflattenPrintSettings(flatSettings, buffer) != 0) {
                SWT.error(2);
            }
            this.printSettings = buffer[0];
            if (this.printSettings == 0) {
                SWT.error(2);
            }
            if (OS.PMUnflattenPageFormat(flatFormat, buffer) != 0) {
                SWT.error(2);
            }
            this.pageFormat = buffer[0];
            if (this.pageFormat == 0) {
                SWT.error(2);
            }
            OS.DisposeHandle(flatSettings);
            OS.DisposeHandle(flatFormat);
        } else {
            if (OS.PMCreatePrintSettings(buffer) != 0) {
                SWT.error(2);
            }
            this.printSettings = buffer[0];
            if (this.printSettings == 0) {
                SWT.error(2);
            }
            OS.PMSessionDefaultPrintSettings(this.printSession, this.printSettings);
            if (OS.PMCreatePageFormat(buffer) != 0) {
                SWT.error(2);
            }
            this.pageFormat = buffer[0];
            if (this.pageFormat == 0) {
                SWT.error(2);
            }
            OS.PMSessionDefaultPageFormat(this.printSession, this.pageFormat);
        }
        if (PREVIEW_DRIVER.equals(this.data.driver)) {
            OS.PMSessionSetDestination(this.printSession, this.printSettings, (short)4, 0, 0);
        }
        String name = this.data.name;
        char[] buffer1 = new char[name.length()];
        name.getChars(0, buffer1.length, buffer1, 0);
        int ptr = OS.CFStringCreateWithCharacters(0, buffer1, buffer1.length);
        if (ptr != 0) {
            OS.PMSessionSetCurrentPrinter(this.printSession, ptr);
            OS.CFRelease(ptr);
        }
        OS.PMSessionValidatePrintSettings(this.printSession, this.printSettings, null);
        OS.PMSessionValidatePageFormat(this.printSession, this.pageFormat, null);
        int graphicsContextsArray = OS.CFArrayCreateMutable(0, 1, 0);
        if (graphicsContextsArray != 0) {
            OS.CFArrayAppendValue(graphicsContextsArray, OS.kPMGraphicsContextCoreGraphics());
            OS.PMSessionSetDocumentFormatGeneration(this.printSession, OS.kPMDocumentFormatPDF(), graphicsContextsArray, 0);
            OS.CFRelease(graphicsContextsArray);
        }
    }

    protected void destroy() {
        if (this.pageFormat != 0) {
            OS.PMRelease(this.pageFormat);
        }
        this.pageFormat = 0;
        if (this.printSettings != 0) {
            OS.PMRelease(this.printSettings);
        }
        this.printSettings = 0;
        if (this.printSession != 0) {
            OS.PMRelease(this.printSession);
        }
        this.printSession = 0;
    }

    public int internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.setupNewPage();
        if (data != null) {
            if (this.isGCCreated) {
                SWT.error(5);
            }
            data.device = this;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
            this.isGCCreated = true;
        }
        return this.context;
    }

    protected void init() {
        super.init();
        this.colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (this.colorspace == 0) {
            SWT.error(2);
        }
    }

    public void internal_dispose_GC(int context, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        if (this.colorspace != 0) {
            OS.CGColorSpaceRelease(this.colorspace);
        }
        this.colorspace = 0;
        super.release();
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        if (jobName != null && jobName.length() != 0) {
            char[] buffer = new char[jobName.length()];
            jobName.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (ptr != 0) {
                OS.PMSetJobNameCFString(this.printSettings, ptr);
                OS.CFRelease(ptr);
            }
        }
        return OS.PMSessionBeginDocumentNoDialog(this.printSession, this.printSettings, this.pageFormat) == 0;
    }

    public void endJob() {
        this.checkDevice();
        if (this.inPage) {
            OS.PMSessionEndPageNoDialog(this.printSession);
            this.inPage = false;
        }
        OS.PMSessionEndDocumentNoDialog(this.printSession);
    }

    public void cancelJob() {
        this.checkDevice();
        OS.PMSessionSetError(this.printSession, 128);
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            PrinterData defaultPrinter = Printer.getDefaultPrinterData();
            if (defaultPrinter == null) {
                SWT.error(2);
            }
            data.driver = defaultPrinter.driver;
            data.name = defaultPrinter.name;
        }
        return data;
    }

    public boolean startPage() {
        this.checkDevice();
        if (OS.PMSessionError(this.printSession) != 0) {
            return false;
        }
        this.setupNewPage();
        return this.context != 0;
    }

    public void endPage() {
        this.checkDevice();
        if (this.inPage) {
            OS.PMSessionEndPageNoDialog(this.printSession);
            this.inPage = false;
        }
    }

    public Point getDPI() {
        this.checkDevice();
        PMResolution resolution = new PMResolution();
        OS.PMGetResolution(this.pageFormat, resolution);
        return new Point((int)resolution.hRes, (int)resolution.vRes);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        PMRect paperRect = new PMRect();
        OS.PMGetAdjustedPaperRect(this.pageFormat, paperRect);
        return new Rectangle(0, 0, (int)(paperRect.right - paperRect.left), (int)(paperRect.bottom - paperRect.top));
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        PMRect pageRect = new PMRect();
        OS.PMGetAdjustedPageRect(this.pageFormat, pageRect);
        return new Rectangle(0, 0, (int)(pageRect.right - pageRect.left), (int)(pageRect.bottom - pageRect.top));
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }

    void setupNewPage() {
        if (!this.inPage) {
            this.inPage = true;
            OS.PMSessionBeginPageNoDialog(this.printSession, this.pageFormat, null);
            int[] buffer = new int[1];
            OS.PMSessionGetGraphicsContext(this.printSession, 0, buffer);
            if (this.context == 0) {
                this.context = buffer[0];
            } else if (this.context != buffer[0]) {
                SWT.error(1);
            }
            PMRect paperRect = new PMRect();
            OS.PMGetAdjustedPaperRect(this.pageFormat, paperRect);
            OS.CGContextScaleCTM(this.context, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(this.context, 0.0f, -((float)(paperRect.bottom - paperRect.top)));
            OS.CGContextSetStrokeColorSpace(this.context, this.colorspace);
            OS.CGContextSetFillColorSpace(this.context, this.colorspace);
        }
    }
}

