/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.spreadsheet.ColCount;
import com.google.gdata.data.spreadsheet.RowCount;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/spreadsheets/2006#worksheet")
public class WorksheetEntry
extends BaseEntry<WorksheetEntry> {
    public static final String KIND = "http://schemas.google.com/spreadsheets/2006#worksheet";
    public static final Category CATEGORY = new Category("http://schemas.google.com/spreadsheets/2006", "http://schemas.google.com/spreadsheets/2006#worksheet");

    public WorksheetEntry() {
        this.getCategories().add(CATEGORY);
    }

    public WorksheetEntry(BaseEntry baseEntry) {
        super(baseEntry);
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extensionProfile) {
        extensionProfile.declareEntryExtension(RowCount.getDefaultDescription());
        extensionProfile.declareEntryExtension(ColCount.getDefaultDescription());
    }

    public URL getListFeedUrl() {
        Link link = this.getLink("http://schemas.google.com/spreadsheets/2006#listfeed", "application/atom+xml");
        try {
            return new URL(link.getHref());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Error in GData server", malformedURLException);
        }
    }

    public URL getCellFeedUrl() {
        Link link = this.getLink("http://schemas.google.com/spreadsheets/2006#cellsfeed", "application/atom+xml");
        try {
            return new URL(link.getHref());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Error in GData server", malformedURLException);
        }
    }

    public int getRowCount() {
        return this.getExtension(RowCount.class).getCount();
    }

    public int getColCount() {
        return this.getExtension(ColCount.class).getCount();
    }
}

