/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.html;

import com.google.gdata.util.common.base.StringUtil;
import java.util.regex.Pattern;

public final class HtmlToText {
    private static final Pattern htmlNewlinePattern = Pattern.compile("\\s*<(br|/?p)>\\s*");
    private static final Pattern htmlListPattern = Pattern.compile("\\s*<li>\\s*");
    private static final Pattern htmlTagPattern = Pattern.compile("</?([^<]*)>");
    public static final int EMAIL_LINE_WIDTH_MAX = 72;

    private HtmlToText() {
    }

    public static String htmlToPlainText(String string) {
        if (string == null) {
            throw new NullPointerException("Html parameter may not be null.");
        }
        String string2 = StringUtil.stripAndCollapse(string);
        string2 = htmlNewlinePattern.matcher(string2).replaceAll("\n");
        string2 = htmlListPattern.matcher(string2).replaceAll("\n- ");
        string2 = htmlTagPattern.matcher(string2).replaceAll("");
        string2 = StringUtil.unescapeHTML(string2).trim();
        return StringUtil.fixedWidth(string2.split("\n"), 72);
    }
}

