/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.Query;
import com.google.gdata.client.Service;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Feed;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFeed<F extends BaseFeed, E extends BaseEntry>
extends Source
implements Kind.Adaptable,
Kind.Adaptor {
    protected FeedState feedState;
    protected Class<? extends E> entryClass;
    protected LinkedList<E> entries = new LinkedList();
    private static final Collection<XmlWriter.Namespace> namespaceDeclsAtom = new Vector<XmlWriter.Namespace>(2);
    private static final Collection<XmlWriter.Namespace> namespaceDeclsRss = new Vector<XmlWriter.Namespace>(2);
    private static final Collection<XmlWriter.Attribute> rssHeaderAttrs = new Vector<XmlWriter.Attribute>(1);

    protected BaseFeed(Class<E> clazz) {
        this.feedState = new FeedState();
        this.entryClass = clazz;
    }

    protected BaseFeed(Class<E> clazz, BaseFeed baseFeed) {
        super(baseFeed);
        this.feedState = baseFeed.feedState;
        this.entryClass = clazz;
    }

    @Override
    public void declareExtensions(ExtensionProfile extensionProfile) {
        E e = this.createEntry();
        extensionProfile.addDeclarations((Kind.Adaptor)e);
    }

    public Service getService() {
        return this.feedState.service;
    }

    public void setService(Service service) {
        this.feedState.service = service;
    }

    public boolean getCanPost() {
        return this.feedState.canPost;
    }

    public void setCanPost(boolean bl) {
        this.feedState.canPost = bl;
    }

    public int getTotalResults() {
        return this.feedState.totalResults;
    }

    public void setTotalResults(int n) {
        this.feedState.totalResults = n;
    }

    public int getStartIndex() {
        return this.feedState.startIndex;
    }

    public void setStartIndex(int n) {
        this.feedState.startIndex = n;
    }

    public int getItemsPerPage() {
        return this.feedState.itemsPerPage;
    }

    public void setItemsPerPage(int n) {
        this.feedState.itemsPerPage = n;
    }

    public List<E> getEntries() {
        return this.entries;
    }

    @Override
    public void addAdaptor(Kind.Adaptor adaptor) {
        this.feedState.adaptable.addAdaptor(adaptor);
    }

    @Override
    public Collection<Kind.Adaptor> getAdaptors() {
        return this.feedState.adaptable.getAdaptors();
    }

    @Override
    public <E extends Kind.Adaptor> E getAdaptor(Class<E> clazz) {
        return this.feedState.adaptable.getAdaptor(clazz);
    }

    public E createEntry() {
        BaseEntry baseEntry;
        try {
            baseEntry = (BaseEntry)this.entryClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        if (this.feedState.service != null) {
            baseEntry.setService(this.feedState.service);
        }
        return (E)baseEntry;
    }

    public Link getEntryPostLink() {
        Link link = this.getLink("http://schemas.google.com/g/2005#post", "application/atom+xml");
        return link;
    }

    public Link getSelfLink() {
        Link link = this.getLink("self", "application/atom+xml");
        return link;
    }

    public F getSelf() throws IOException, ServiceException {
        if (this.feedState.service == null) {
            throw new ServiceException("Feed is not associated with a GData service");
        }
        Link link = this.getSelfLink();
        if (link == null) {
            throw new UnsupportedOperationException("Feed cannot be retrieved");
        }
        URL uRL = new URL(link.getHref());
        try {
            return (F)this.feedState.service.getFeed(uRL, this.getClass(), this.srcState.updated);
        }
        catch (NotModifiedException notModifiedException) {
            return (F)this;
        }
    }

    public E insert(E e) throws ServiceException, IOException {
        if (this.feedState.service == null) {
            throw new ServiceException("Entry is not associated with GData service");
        }
        Link link = this.getEntryPostLink();
        if (link == null) {
            throw new UnsupportedOperationException("Entry cannot be inserted");
        }
        URL uRL = new URL(link.getHref());
        return this.feedState.service.insert(uRL, e);
    }

    @Override
    public void generateAtom(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        this.generateFeedStart(extensionProfile, xmlWriter, null);
        this.generateEntries(xmlWriter, extensionProfile);
        this.generateFeedEnd(xmlWriter);
    }

    private void generateEntries(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        xmlWriter.startRepeatingElement();
        for (BaseEntry baseEntry : this.entries) {
            baseEntry.generateAtom(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
    }

    public void generateFeedEnd(XmlWriter xmlWriter) throws IOException {
        xmlWriter.endElement(Namespaces.atomNs, "feed");
    }

    public void generateFeedStart(ExtensionProfile extensionProfile, XmlWriter xmlWriter, Collection<XmlWriter.Namespace> collection) throws IOException {
        Vector<XmlWriter.Namespace> vector = new Vector<XmlWriter.Namespace>(namespaceDeclsAtom);
        vector.addAll(extensionProfile.getNamespaceDecls());
        this.generateStartElement(xmlWriter, Namespaces.atomNs, "feed", null, vector);
        this.generateInnerAtom(xmlWriter, extensionProfile);
        if (this.feedState.totalResults != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "totalResults", null, String.valueOf(this.feedState.totalResults));
        }
        if (this.feedState.startIndex != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "startIndex", null, String.valueOf(this.feedState.startIndex));
        }
        if (this.feedState.itemsPerPage != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "itemsPerPage", null, String.valueOf(this.feedState.itemsPerPage));
        }
        this.generateExtensions(xmlWriter, extensionProfile);
    }

    public void generateRss(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        String string;
        Object object;
        Vector<XmlWriter.Namespace> vector = new Vector<XmlWriter.Namespace>(namespaceDeclsRss);
        vector.addAll(extensionProfile.getNamespaceDecls());
        xmlWriter.startElement(Namespaces.rssNs, "rss", rssHeaderAttrs, vector);
        this.generateStartElement(xmlWriter, Namespaces.rssNs, "channel", null, null);
        if (this.srcState.id != null) {
            xmlWriter.simpleElement(Namespaces.atomNs, "id", null, this.srcState.id);
        }
        if (this.xmlBlob != null && (object = this.xmlBlob.getLang()) != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "language", null, (String)object);
        }
        if (this.srcState.updated != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "lastBuildDate", null, this.srcState.updated.toStringRfc822());
        }
        xmlWriter.startRepeatingElement();
        for (Category iterator2 : this.srcState.categories) {
            iterator2.generateRss(xmlWriter);
        }
        xmlWriter.endRepeatingElement();
        if (this.srcState.title != null) {
            this.srcState.title.generateRss(xmlWriter, "title", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.srcState.subtitle != null) {
            this.srcState.subtitle.generateRss(xmlWriter, "description", TextConstruct.RssFormat.FULL_HTML);
        } else {
            xmlWriter.simpleElement(Namespaces.rssNs, "description", null, null);
        }
        object = this.getHtmlLink();
        if (object != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "link", null, ((Link)object).getHref());
        }
        if (this.srcState.logo != null || this.srcState.icon != null) {
            xmlWriter.startElement(Namespaces.rssNs, "image", null, null);
            xmlWriter.simpleElement(Namespaces.rssNs, "url", null, this.srcState.logo != null ? this.srcState.logo : this.srcState.icon);
            if (object != null) {
                xmlWriter.simpleElement(Namespaces.rssNs, "link", null, ((Link)object).getHref());
            }
            xmlWriter.endElement(Namespaces.rssNs, "image");
        }
        if (this.srcState.rights != null) {
            this.srcState.rights.generateRss(xmlWriter, "copyright", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.srcState.authors.size() > 0) {
            this.srcState.authors.get(0).generateRss(xmlWriter, "managingEditor");
        }
        if (this.srcState.generator != null && (string = this.srcState.generator.getName()) != null) {
            xmlWriter.simpleElement(Namespaces.rssNs, "generator", null, string);
        }
        if (this.feedState.totalResults != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "totalResults", null, String.valueOf(this.feedState.totalResults));
        }
        if (this.feedState.startIndex != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "startIndex", null, String.valueOf(this.feedState.startIndex));
        }
        if (this.feedState.itemsPerPage != Query.UNDEFINED) {
            xmlWriter.simpleElement(Namespaces.openSearchNs, "itemsPerPage", null, String.valueOf(this.feedState.itemsPerPage));
        }
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.startRepeatingElement();
        for (BaseEntry baseEntry : this.entries) {
            baseEntry.generateRss(xmlWriter, extensionProfile);
        }
        xmlWriter.endRepeatingElement();
        xmlWriter.endElement(Namespaces.rssNs, "channel");
        xmlWriter.endElement(Namespaces.rssNs, "rss");
    }

    @Override
    public void parseAtom(ExtensionProfile extensionProfile, InputStream inputStream) throws IOException, ParseException {
        FeedHandler feedHandler = new FeedHandler(extensionProfile);
        new XmlParser().parse(inputStream, (XmlParser.ElementHandler)feedHandler, "http://www.w3.org/2005/Atom", "feed");
    }

    @Override
    public void parseAtom(ExtensionProfile extensionProfile, Reader reader) throws IOException, ParseException {
        FeedHandler feedHandler = new FeedHandler(extensionProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)feedHandler, "http://www.w3.org/2005/Atom", "feed");
    }

    static {
        namespaceDeclsAtom.add(Namespaces.atomNs);
        namespaceDeclsAtom.add(Namespaces.openSearchNs);
        namespaceDeclsRss.add(Namespaces.atomNs);
        namespaceDeclsRss.add(Namespaces.openSearchNs);
        rssHeaderAttrs.add(new XmlWriter.Attribute("version", "2.0"));
    }

    public class FeedHandler
    extends Source.SourceHandler {
        public FeedHandler(ExtensionProfile extensionProfile) throws IOException {
            super(BaseFeed.this, extensionProfile, Feed.class);
        }

        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) throws ParseException, IOException {
            XmlParser.ElementHandler elementHandler = BaseFeed.this.getExtensionHandler(this.extProfile, Feed.class, string, string2, attributes);
            if (elementHandler != null) {
                return elementHandler;
            }
            if (string.equals("http://www.w3.org/2005/Atom")) {
                if (string2.equals("entry")) {
                    Object e = BaseFeed.this.createEntry();
                    BaseFeed.this.entries.add(e);
                    Object e2 = e;
                    e2.getClass();
                    return (BaseEntry)e2.new BaseEntry.AtomHandler(this.extProfile);
                }
                return super.getChildHandler(string, string2, attributes);
            }
            if (string.equals("http://a9.com/-/spec/opensearchrss/1.0/")) {
                if (string2.equals("totalResults")) {
                    return new TotalResultsHandler();
                }
                if (string2.equals("startIndex")) {
                    return new StartIndexHandler();
                }
                if (string2.equals("itemsPerPage")) {
                    return new ItemsPerPageHandler();
                }
            } else {
                return super.getChildHandler(string, string2, attributes);
            }
            return null;
        }

        public void processEndElement() throws ParseException {
            BaseFeed.this.feedState.canPost = BaseFeed.this.getEntryPostLink() != null;
        }

        private class ItemsPerPageHandler
        extends XmlParser.ElementHandler {
            private ItemsPerPageHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.itemsPerPage != Query.UNDEFINED) {
                    throw new ParseException("Duplicate itemsPerPage.");
                }
                if (this.value == null) {
                    throw new ParseException("logo must have a value.");
                }
                try {
                    BaseFeed.this.feedState.itemsPerPage = Integer.valueOf(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("itemsPerPage is not an integer");
                }
            }
        }

        private class StartIndexHandler
        extends XmlParser.ElementHandler {
            private StartIndexHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.startIndex != Query.UNDEFINED) {
                    throw new ParseException("Duplicate startIndex.");
                }
                if (this.value == null) {
                    throw new ParseException("logo must have a value.");
                }
                try {
                    BaseFeed.this.feedState.startIndex = Integer.valueOf(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("startIndex must be an integer");
                }
            }
        }

        private class TotalResultsHandler
        extends XmlParser.ElementHandler {
            private TotalResultsHandler() {
            }

            public void processEndElement() throws ParseException {
                if (BaseFeed.this.feedState.totalResults != Query.UNDEFINED) {
                    throw new ParseException("Duplicate totalResults.");
                }
                if (this.value == null) {
                    throw new ParseException("logo must have a value.");
                }
                try {
                    BaseFeed.this.feedState.totalResults = Integer.valueOf(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("totalResults is not an integer");
                }
            }
        }
    }

    protected static class FeedState {
        public Service service;
        public boolean canPost = true;
        public int totalResults = Query.UNDEFINED;
        public int startIndex = Query.UNDEFINED;
        public int itemsPerPage = Query.UNDEFINED;
        public Kind.Adaptable adaptable = new Kind.AdaptableHelper();

        protected FeedState() {
        }
    }
}

