/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateUtilities {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss 'GMT'", new DateFormatSymbols(Locale.US));

    private DateUtilities() {
    }

    public static long getDateLong(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 1000000 + (cal.get(2) + 1) * 100 + cal.get(5);
    }

    public static String getGMTString(Date date) {
        return SDF.format(date);
    }

    public static Date getGMTDate(String date) {
        try {
            return SDF.parse(date);
        }
        catch (Exception e) {
            return new Date();
        }
    }
}

