/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;

public class ImportTree
extends Command {
    Command addDocument = null;
    Command addCollection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Hashtable table) throws Exception {
        Collection col = null;
        try {
            this.addDocument = (Command)Class.forName("org.apache.xindice.tools.command.AddDocument").newInstance();
            this.addCollection = (Command)Class.forName("org.apache.xindice.tools.command.AddCollection").newInstance();
            String startcollection = null;
            if (table.get("filePath") == null) {
                System.out.println("ERROR : Directory name and switch required");
                boolean bl = false;
                return bl;
            }
            if (table.get("collection") == null) {
                System.out.println("ERROR : Collection name and switch required");
                boolean bl = false;
                return bl;
            }
            startcollection = (String)table.get("collection");
            String colstring = this.normalizeCollectionURI(startcollection, (String)table.get("local"));
            col = DatabaseManager.getCollection((String)colstring);
            if (col == null) {
                System.out.println("ERROR : Collection not found!");
                boolean bl = false;
                return bl;
            }
            File startdir = new File((String)table.get("filePath"));
            this.process(startdir, colstring, table);
        }
        finally {
            if (col != null) {
                col.close();
            }
        }
        return true;
    }

    void process(File directory, String baseCollection, Hashtable table) {
        try {
            String ext = (String)table.get("extension");
            if (!directory.isDirectory()) {
                System.out.println("ERROR: The specified import path is not a directory " + directory.getPath());
                return;
            }
            baseCollection = this.createCollection(baseCollection, directory.getName());
            File[] subdirs = directory.listFiles(new ExtensionFileFilter(ext));
            for (int i = 0; i < subdirs.length; ++i) {
                if (subdirs[i].isDirectory()) {
                    this.process(subdirs[i], baseCollection, table);
                    continue;
                }
                this.importFile(baseCollection, subdirs[i].getAbsolutePath(), subdirs[i].getName());
            }
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e.getMessage());
            if (table.get("verbose").equals("true")) {
                e.printStackTrace(System.err);
            }
            return;
        }
    }

    protected void importFile(String baseCollection, String path, String name) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("collection", baseCollection);
        table.put("filePath", path);
        table.put("nameOf", name);
        this.addDocument.execute(table);
    }

    protected String createCollection(String baseCollection, String newCollection) throws Exception {
        if (!newCollection.equals(".")) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("collection", baseCollection);
            table.put("nameOf", newCollection);
            this.addCollection.execute(table);
        } else {
            newCollection = "";
        }
        return baseCollection + "/" + newCollection;
    }

    private static class ExtensionFileFilter
    implements FileFilter {
        private String extension = "";

        public ExtensionFileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File pathname) {
            if (this.extension != "") {
                return pathname.getName().endsWith("." + this.extension) || pathname.isDirectory();
            }
            return true;
        }
    }
}

