/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.Shape;

public final class IntAffineMatrix {
    public static final IntAffineMatrix IDENTITY = new IntAffineMatrix(1, 0, 0, 0, 1, 0);
    public static final IntAffineMatrix ROT_90 = new IntAffineMatrix(0, -1, 0, 1, 0, 0);
    public static final IntAffineMatrix ROT_180 = new IntAffineMatrix(-1, 0, 0, 0, -1, 0);
    public static final IntAffineMatrix ROT_270 = new IntAffineMatrix(0, 1, 0, -1, 0, 0);
    public static final IntAffineMatrix FLIP_XAXIS = new IntAffineMatrix(1, 0, 0, 0, -1, 0);
    public static final IntAffineMatrix FLIP_YAXIS = new IntAffineMatrix(-1, 0, 0, 0, 1, 0);
    int m11;
    int m12;
    int m13;
    int m21;
    int m22;
    int m23;

    public IntAffineMatrix() {
        this(1, 0, 0, 0, 1, 0);
    }

    public IntAffineMatrix(int _m11, int _m12, int _m13, int _m21, int _m22, int _m23) {
        this.m11 = _m11;
        this.m12 = _m12;
        this.m13 = _m13;
        this.m21 = _m21;
        this.m22 = _m22;
        this.m23 = _m23;
    }

    public IntAffineMatrix(IntAffineMatrix toCopy) {
        this(toCopy.m11, toCopy.m12, toCopy.m13, toCopy.m21, toCopy.m22, toCopy.m23);
    }

    public IntAffineMatrix inverse() {
        int det = this.det();
        return new IntAffineMatrix(this.m22 / det, -this.m12 / det, (this.m12 * this.m23 - this.m22 * this.m13) / det, -this.m21 / det, this.m11 / det, (this.m21 * this.m13 - this.m11 * this.m23) / det);
    }

    public static IntAffineMatrix getRotation(int swtDirectionConstant) {
        switch (swtDirectionConstant) {
            case 131072: {
                return ROT_90;
            }
            case 1024: {
                return ROT_180;
            }
            case 16384: {
                return ROT_270;
            }
        }
        return IDENTITY;
    }

    public int det() {
        return this.m11 * this.m22 - this.m12 * this.m21;
    }

    public static IntAffineMatrix translation(int x, int y) {
        return new IntAffineMatrix(1, 0, x, 0, 1, y);
    }

    public static IntAffineMatrix translation(Point vector) {
        return new IntAffineMatrix(1, 0, vector.x, 0, 1, vector.y);
    }

    public IntAffineMatrix multiply(IntAffineMatrix m) {
        IntAffineMatrix result = new IntAffineMatrix(this.m11 * m.m11 + this.m12 * m.m21, this.m11 * m.m12 + this.m12 * m.m22, this.m11 * m.m13 + this.m12 * m.m23 + this.m13, this.m21 * m.m11 + this.m22 * m.m21, this.m21 * m.m12 + this.m22 * m.m22, this.m21 * m.m13 + this.m22 * m.m23 + this.m23);
        return result;
    }

    public void transform(int[] source, int sourcePos, int[] dest, int destPos, int length) {
        int nextSrc = sourcePos * 2;
        int nextDest = destPos * 2;
        int i = 0;
        while (i < length) {
            int sourcex = source[nextSrc++];
            int sourcey = source[nextSrc++];
            dest[nextDest++] = this.getx(sourcex, sourcey);
            dest[nextDest++] = this.gety(sourcex, sourcey);
            ++i;
        }
    }

    public int gety(int sourcex, int sourcey) {
        return sourcex * this.m21 + sourcey * this.m22 + this.m23;
    }

    public int getx(int sourcex, int sourcey) {
        return sourcex * this.m11 + sourcey * this.m12 + this.m13;
    }

    public Shape transform(Shape toTransform) {
        int[] newArray = new int[toTransform.used];
        this.transform(toTransform.data, 0, newArray, 0, toTransform.used / 2);
        return new Shape(newArray);
    }

    public Point multiply(Point toTransform) {
        return new Point(toTransform.x * this.m11 + toTransform.y * this.m12 + this.m13, toTransform.x * this.m21 + toTransform.y * this.m22 + this.m23);
    }
}

