/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.net.URL;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class EclipseLazyStarter
implements ClassLoadingStatsHook,
HookConfigurator {
    public void preFindLocalClass(String name, ClasspathManager manager) throws ClassNotFoundException {
        AbstractBundle bundle = (AbstractBundle)manager.getBaseData().getBundle();
        if ((bundle.getState() & 0x31) != 0) {
            return;
        }
        EclipseStorageHook storageHook = (EclipseStorageHook)manager.getBaseData().getStorageHook(EclipseStorageHook.KEY);
        if (!this.shouldActivateFor(name, manager.getBaseData(), storageHook)) {
            return;
        }
        if (bundle.getState() == 8) {
            if (bundle.testStateChanging(Thread.currentThread()) || bundle.testStateChanging(null)) {
                return;
            }
            if (!bundle.testStateChanging(Thread.currentThread())) {
                long delay;
                Thread threadChangingState = bundle.getStateChanging();
                if (StatsManager.TRACE_BUNDLES && threadChangingState != null) {
                    System.out.println("Concurrent startup of bundle " + bundle.getSymbolicName() + " by " + Thread.currentThread() + " and " + threadChangingState.getName() + ". Waiting up to 5000ms for " + threadChangingState + " to finish the initialization.");
                }
                long start = System.currentTimeMillis();
                long timeLeft = delay = 5000L;
                while (true) {
                    try {
                        Thread.sleep(100L);
                        if (bundle.testStateChanging(null) || timeLeft <= 0L) {
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    timeLeft = start + delay - System.currentTimeMillis();
                }
                if (timeLeft <= 0L || bundle.getState() != 32) {
                    String bundleName = bundle.getSymbolicName() == null ? Long.toString(bundle.getBundleId()) : bundle.getSymbolicName();
                    String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread().getName(), name, threadChangingState.getName(), bundleName, Long.toString(delay)});
                    manager.getBaseData().getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, new Exception(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_GENERATED_EXCEPTION), null));
                }
                return;
            }
        }
        try {
            if (storageHook != null) {
                storageHook.setActivatedOnClassLoad(true);
            }
            bundle.start();
        }
        catch (BundleException e) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ACTIVATION, bundle.getSymbolicName(), Long.toString(bundle.getBundleId()));
            manager.getBaseData().getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null));
            throw new ClassNotFoundException(name, e);
        }
    }

    public void postFindLocalClass(String name, Class clazz, ClasspathManager manager) {
    }

    public void preFindLocalResource(String name, ClasspathManager manager) {
    }

    public void postFindLocalResource(String name, URL resource, ClasspathManager manager) {
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
    }

    private boolean shouldActivateFor(String className, BaseData bundledata, EclipseStorageHook storageHook) throws ClassNotFoundException {
        BundleStopper stopper;
        if (!this.isAutoStartable(className, bundledata, storageHook)) {
            return false;
        }
        if (bundledata.getAdaptor().isStopping() && (stopper = EclipseStorageHook.getBundleStopper(bundledata)) != null && stopper.isStopped(bundledata.getBundle())) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ALREADY_STOPPED, className, bundledata.getSymbolicName());
            throw new ClassNotFoundException(message);
        }
        return true;
    }

    private boolean isAutoStartable(String className, BaseData bundledata, EclipseStorageHook storageHook) {
        if (storageHook == null) {
            return false;
        }
        boolean autoStart = storageHook.isAutoStart();
        String[] autoStartExceptions = storageHook.getAutoStartExceptions();
        if (autoStartExceptions == null) {
            return autoStart;
        }
        int dotPosition = className.lastIndexOf(46);
        if (dotPosition == -1) {
            return autoStart;
        }
        String packageName = className.substring(0, dotPosition);
        return autoStart ^ this.contains(autoStartExceptions, packageName);
    }

    private boolean contains(String[] array, String element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingStatsHook(this);
    }
}

