/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XPathQuery
extends Command {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$tools$command$XPathQuery == null ? (class$org$apache$xindice$tools$command$XPathQuery = XPathQuery.class$("org.apache.xindice.tools.command.XPathQuery")) : class$org$apache$xindice$tools$command$XPathQuery));
    static /* synthetic */ Class class$org$apache$xindice$tools$command$XPathQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Hashtable table) throws Exception {
        Collection col = null;
        try {
            if ((String)table.get("collection") == null) {
                System.out.println("ERROR : Collection name and switch required");
                boolean bl = false;
                return bl;
            }
            if ((String)table.get("query") == "") {
                System.out.println("ERROR : Query and switch required");
                boolean bl = false;
                return bl;
            }
            String colstring = this.normalizeCollectionURI((String)table.get("collection"), (String)table.get("local"));
            String querystring = (String)table.get("query");
            XPathQueryService service = null;
            ResourceIterator results = null;
            col = DatabaseManager.getCollection((String)colstring);
            if (col == null) {
                System.out.println("ERROR : Collection not found!");
                boolean bl = false;
                return bl;
            }
            service = (XPathQueryService)col.getService("XPathQueryService", "1.0");
            this.addNamespaces(service, (String)table.get("namespaces"));
            ResourceSet resultSet = service.query(querystring);
            results = resultSet.getIterator();
            while (results.hasMoreResources()) {
                XMLResource resource = (XMLResource)results.nextResource();
                String documentstr = (String)resource.getContent();
                System.out.println(documentstr);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e.getMessage());
            if (table.get("verbose").equals("true") && log.isWarnEnabled()) {
                log.warn((Object)"ignored exception", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (col != null) {
                col.close();
            }
        }
        return true;
    }

    private void addNamespaces(XPathQueryService service, String namespacesString) throws XMLDBException {
        if (namespacesString != "" && namespacesString != null) {
            StringTokenizer st = new StringTokenizer(namespacesString, "=;");
            if (st.countTokens() % 2 != 0) {
                System.out.println("ERROR : mismatched namespace prefixes and uris");
                return;
            }
            while (st.hasMoreTokens()) {
                service.setNamespace(st.nextToken(), st.nextToken());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

