/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.util.Map;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;

public abstract class DBObserver {
    private static final DBObserver NOOP;
    private static DBObserver instance;

    public static void setInstance(DBObserver obs) {
        instance = null == obs ? NOOP : obs;
    }

    public static DBObserver getInstance() {
        return instance;
    }

    public abstract void setDatabaseConfig(Database var1, Map var2, Configuration var3);

    public abstract void setCollectionConfig(Collection var1, Configuration var2);

    public abstract void flushDatabaseConfig(Database var1, Configuration var2);

    public abstract void dropCollection(Collection var1) throws DBException;

    public abstract void createCollection(Collection var1) throws DBException;

    public abstract void putDocument(Collection var1, Key var2, Document var3, boolean var4) throws DBException;

    public abstract void loadDocument(Collection var1, Record var2, Document var3) throws DBException;

    public abstract void dropDocument(Collection var1, Key var2) throws DBException;

    static {
        instance = NOOP = new DBObserver(){

            public void setDatabaseConfig(Database db, Map collections, Configuration cfg) {
            }

            public void setCollectionConfig(Collection col, Configuration cfg) {
            }

            public void flushDatabaseConfig(Database db, Configuration cfg) {
            }

            public void dropCollection(Collection col) {
            }

            public void createCollection(Collection col) {
            }

            public void putDocument(Collection col, Key key, Document document, boolean create) {
            }

            public void loadDocument(Collection col, Record record, Document document) {
            }

            public void dropDocument(Collection col, Key key) {
            }
        };
    }
}

