/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LockManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$util$LockManager == null ? (class$org$apache$xindice$util$LockManager = LockManager.class$("org.apache.xindice.util.LockManager")) : class$org$apache$xindice$util$LockManager));
    private int maxLocks = 0;
    private Map locks = new HashMap();
    static /* synthetic */ Class class$org$apache$xindice$util$LockManager;

    public LockManager(int maxLocks) {
        this.maxLocks = maxLocks;
    }

    public void acquireSharedLock(long id) {
        this.acquireSharedLock(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireSharedLock(Object key) {
        LockInfo info;
        Object object = this;
        synchronized (object) {
            info = (LockInfo)this.locks.get(key);
            if (info == null) {
                info = new LockInfo();
                this.locks.put(key, info);
            }
        }
        object = info;
        synchronized (object) {
            while (info.count >= this.maxLocks) {
                try {
                    info.wait();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
            ++info.count;
        }
    }

    public void releaseSharedLock(long id) {
        this.releaseSharedLock(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedLock(Object key) {
        LockInfo info;
        Object object = this;
        synchronized (object) {
            info = (LockInfo)this.locks.get(key);
        }
        if (info == null) {
            return;
        }
        object = info;
        synchronized (object) {
            --info.count;
            info.notify();
            if (info.count == 0) {
                LockManager lockManager = this;
                synchronized (lockManager) {
                    this.locks.remove(key);
                }
            }
        }
    }

    public void acquireExclusiveLock(long id) {
        this.acquireExclusiveLock(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusiveLock(Object key) {
        LockInfo info;
        Object object = this;
        synchronized (object) {
            info = (LockInfo)this.locks.get(key);
            if (info == null) {
                info = new LockInfo();
                this.locks.put(key, info);
            }
        }
        object = info;
        synchronized (object) {
            int total = 0;
            int stolen = 0;
            while (total < this.maxLocks && info.count >= this.maxLocks) {
                block10: {
                    try {
                        info.wait();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                stolen = this.maxLocks - info.count;
                total += stolen;
                info.count += stolen;
            }
        }
    }

    public void releaseExclusiveLock(long id) {
        this.releaseExclusiveLock(new Long(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusiveLock(Object key) {
        LockInfo info;
        Object object = this;
        synchronized (object) {
            info = (LockInfo)this.locks.get(key);
        }
        if (info == null) {
            return;
        }
        object = info;
        synchronized (object) {
            info.count = 0;
            info.notify();
            if (info.count == 0) {
                LockManager lockManager = this;
                synchronized (lockManager) {
                    this.locks.remove(key);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LockInfo {
        public int count = 0;

        private LockInfo() {
        }
    }
}

