/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.DBObserver;
import org.apache.xindice.core.DocumentCache;
import org.apache.xindice.core.MetaSystemCollection;
import org.apache.xindice.core.SystemCollection;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationException;
import org.apache.xindice.util.Named;
import org.apache.xindice.util.XindiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Database
extends Collection
implements Named {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$Database == null ? (class$org$apache$xindice$core$Database = Database.class$("org.apache.xindice.core.Database")) : class$org$apache$xindice$core$Database));
    public static final String DBROOT = "dbroot";
    public static final String NAME = "name";
    private static final String QUERYENGINE = "queryengine";
    private static final String COLKEY = "database.xml";
    private static final String DATABASE = "database";
    private static final String METADATA = "use-metadata";
    public static final String DBROOT_DEFAULT = "./db/";
    private static final Map databases = new HashMap();
    private DocumentCache docCache = new DocumentCache();
    private QueryEngine engine = new QueryEngine(this);
    private boolean metaEnabled = false;
    private boolean metaInit = false;
    private MetaSystemCollection metaSystemCollection = null;
    private boolean sysInit = false;
    private SystemCollection systemCollection = null;
    static /* synthetic */ Class class$org$apache$xindice$core$Database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(Configuration config) {
        String name = config.getAttribute(NAME);
        if (null == name) {
            throw new ConfigurationException("Database configuration didn't contain a database name");
        }
        Database database = (Database)databases.get(name);
        if (null == database) {
            Map map = databases;
            synchronized (map) {
                database = (Database)databases.get(name);
                if (null == database) {
                    database = new Database();
                    try {
                        database.setConfig(config);
                    }
                    catch (XindiceException x) {
                        throw new ConfigurationException(x);
                    }
                    databases.put(database.getName(), database);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String name) {
        Database database = (Database)databases.get(name);
        if (null == database) {
            Map map = databases;
            synchronized (map) {
                database = (Database)databases.get(name);
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listDatabases() {
        Map map = databases;
        synchronized (map) {
            return databases.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() throws DBException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Shutting down database: '" + this.getName() + "'"));
        }
        this.flushConfig();
        super.close();
        Map map = databases;
        synchronized (map) {
            databases.remove(this.getName());
        }
        return true;
    }

    public void flushConfig() {
        if (this.getConfig().isDirty()) {
            try {
                Document d = this.getConfig().getElement().getOwnerDocument();
                this.systemCollection.getCollection("SysConfig").setDocument(COLKEY, d);
                this.getConfig().resetDirty();
            }
            catch (Exception e) {
                log.error((Object)("Error Writing Configuration '" + this.getName() + "', for database " + this.getName()), (Throwable)e);
            }
            DBObserver.getInstance().flushDatabaseConfig(this, this.getConfig());
        }
    }

    public Database getDatabase() {
        return this;
    }

    public DocumentCache getDocumentCache() {
        return this.docCache;
    }

    public MetaSystemCollection getMetaSystemCollection() {
        return this.metaSystemCollection;
    }

    public QueryEngine getQueryEngine() {
        return this.engine;
    }

    public SystemCollection getSystemCollection() {
        return this.systemCollection;
    }

    public boolean isMetaEnabled() {
        return this.metaEnabled;
    }

    public void setConfig(Configuration config) throws XindiceException {
        block15: {
            block14: {
                super.setConfig(config);
                this.setCanonicalName('/' + this.getName());
                String dbroot = config.getAttribute(DBROOT);
                File dbrootDir = new File(dbroot);
                if (!dbrootDir.isAbsolute()) {
                    log.warn((Object)("The specified database root directory '" + dbroot + "' is relative. " + "Using property " + "xindice.db.home" + " to resolve."));
                    String home = System.getProperty("xindice.db.home");
                    if (home == null) {
                        log.warn((Object)("The specified database root directory '" + dbroot + "' is relative " + "and there was no " + "xindice.db.home" + " property set, " + "so Xindice was unable to determine a database location. " + "Database will be created relative to the current working directory."));
                        home = ".";
                    }
                    try {
                        dbrootDir = new File(home, dbroot).getCanonicalFile();
                    }
                    catch (IOException e) {
                        throw new XindiceException("Can't get canonical path", e);
                    }
                }
                this.setCollectionRoot(dbrootDir);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Database points to " + dbrootDir.getAbsolutePath()));
                }
                try {
                    Configuration queryCfg = config.getChild(QUERYENGINE);
                    if (queryCfg != null) {
                        this.engine.setConfig(queryCfg);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block14;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
            if (!this.sysInit) {
                this.systemCollection = new SystemCollection(this);
                this.systemCollection.init();
                super.addCollection(this.systemCollection);
                this.sysInit = true;
            }
            try {
                Document colDoc = this.systemCollection.getCollection("SysConfig").getDocument(COLKEY);
                if (colDoc == null) {
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    colDoc = db.newDocument();
                    Element root = colDoc.createElement(DATABASE);
                    root.setAttribute(NAME, this.getName());
                    colDoc.appendChild(root);
                    this.systemCollection.getCollection("SysConfig").setDocument(COLKEY, colDoc);
                }
                super.setConfig(new Configuration(colDoc.getDocumentElement(), false));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block15;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        String metaCfg = config.getAttribute(METADATA);
        if (metaCfg.equalsIgnoreCase("on")) {
            this.metaEnabled = true;
            if (!this.metaInit) {
                this.metaSystemCollection = new MetaSystemCollection(this);
                this.metaSystemCollection.init();
                super.addCollection(this.metaSystemCollection);
                this.metaInit = true;
                log.debug((Object)"Meta information initialized");
            }
        }
        DBObserver.getInstance().setDatabaseConfig(this, this.getCollections(), config);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

