/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.osgi.framework.BundleException;

public class SystemBundleData
extends BaseData {
    private static final String OSGI_FRAMEWORK = "osgi.framework";

    public SystemBundleData(BaseAdaptor adaptor) throws BundleException {
        super(0L, adaptor);
        File osgiBase = this.getOsgiBase();
        this.createBundleFile(osgiBase);
        this.manifest = this.createManifest(osgiBase);
        this.setMetaData();
        this.setLastModified(System.currentTimeMillis());
    }

    private File getOsgiBase() {
        String frameworkLocation = FrameworkProperties.getProperty(OSGI_FRAMEWORK);
        if (frameworkLocation != null) {
            return new File(frameworkLocation.substring(5));
        }
        try {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            return new File(url.getPath());
        }
        catch (Throwable throwable) {
            frameworkLocation = FrameworkProperties.getProperty("user.dir");
            if (frameworkLocation != null) {
                return new File(frameworkLocation);
            }
            return null;
        }
    }

    private Headers createManifest(File osgiBase) throws BundleException {
        InputStream in = null;
        if (osgiBase != null && osgiBase.exists()) {
            try {
                BundleEntry entry = this.getBundleFile().getEntry("META-INF/MANIFEST.MF");
                if (entry != null) {
                    in = entry.getInputStream();
                }
            }
            catch (IOException iOException) {}
        }
        if (in == null) {
            in = this.getManifestAsResource();
        }
        if (Debug.DEBUG_GENERAL && in == null) {
            Debug.println("Unable to find system bundle manifest META-INF/MANIFEST.MF");
        }
        if (in == null) {
            throw new BundleException(AdaptorMsg.SYSTEMBUNDLE_MISSING_MANIFEST);
        }
        return Headers.parseManifest(in);
    }

    private InputStream getManifestAsResource() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> manifests = cl != null ? cl.getResources("META-INF/MANIFEST.MF") : ClassLoader.getSystemResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL url = manifests.nextElement();
                try {
                    Headers headers = Headers.parseManifest(url.openStream());
                    if (!"true".equals(headers.get("Eclipse-SystemBundle"))) continue;
                    return url.openStream();
                }
                catch (BundleException bundleException) {}
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void createBundleFile(File osgiBase) {
        if (osgiBase != null) {
            try {
                this.bundleFile = this.getAdaptor().createBundleFile(osgiBase, this);
            }
            catch (IOException iOException) {}
        } else {
            this.bundleFile = new BundleFile(osgiBase){

                public File getFile(String path, boolean nativeCode) {
                    return null;
                }

                public BundleEntry getEntry(String path) {
                    return null;
                }

                public Enumeration getEntryPaths(String path) {
                    return null;
                }

                public void close() {
                }

                public void open() {
                }

                public boolean containsDir(String dir) {
                    return false;
                }
            };
        }
    }

    private void setMetaData() throws BundleException {
        this.setLocation("System Bundle");
        BaseStorageHook.loadManifest(this, this.manifest);
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, BundleProtectionDomain domain, String[] bundleclasspath) {
        return null;
    }

    public File createGenerationDir() {
        return null;
    }

    public String findLibrary(String libname) {
        return null;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
    }

    public File getDataFile(String path) {
        return null;
    }

    public int getStartLevel() {
        return 0;
    }

    public int getStatus() {
        return 0;
    }

    public void save() {
    }
}

