/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUIMessages;

public class MirrorsDialog
extends Dialog {
    private String siteName;
    private IURLEntry[] mirrors;
    private List mirrorsList;
    private IURLEntry mirrorSelected;

    public MirrorsDialog(Shell parentShell, ISiteWithMirrors site, String siteName) {
        super(parentShell);
        this.siteName = siteName;
        try {
            this.mirrors = site.getMirrorSiteEntries();
        }
        catch (CoreException coreException) {}
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 450;
        data.heightHint = 300;
        composite.setLayoutData((Object)data);
        Text text = new Text(composite, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        text.setText(NLS.bind((String)UpdateUIMessages.MirrorsDialog_text, (Object)this.siteName));
        text.setBackground(parent.getBackground());
        text.setEditable(false);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MirrorsDialog.this.mirrorsList.setFocus();
            }
        });
        this.mirrorsList = new List(composite, 2816);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.mirrorsList.setLayoutData((Object)data);
        this.mirrorsList.add(this.siteName);
        int i = 0;
        while (i < this.mirrors.length) {
            this.mirrorsList.add(this.mirrors[i].getAnnotation());
            ++i;
        }
        this.mirrorsList.select(0);
        Dialog.applyDialogFont((Control)composite);
        this.mirrorsList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                MirrorsDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        return composite;
    }

    protected void okPressed() {
        int i = this.mirrorsList.getSelectionIndex();
        if (i > 0) {
            this.mirrorSelected = this.mirrors[i - 1];
        }
        super.okPressed();
    }

    public IURLEntry getMirror() {
        return this.mirrorSelected;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UpdateUIMessages.MirrorsDialog_title);
    }
}

