/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class ExportTree
extends Command {
    public boolean execute(Hashtable table) throws Exception {
        Collection col = null;
        if (table.get("filePath").equals("")) {
            System.out.println("ERROR: Directory name and switch required");
            return false;
        }
        if (table.get("collection") == null) {
            System.out.println("ERROR : Collection name and switch required");
            return false;
        }
        File fp = new File((String)table.get("filePath"));
        System.out.println();
        if (table.get("collection") != null) {
            String parent = this.parentDir((String)table.get("collection"));
            File dir = new File(fp, parent);
            System.out.println("Creating directory " + dir.getPath());
            dir.mkdir();
            this.process(dir, table, col);
        }
        return true;
    }

    private String parentDir(String parent) {
        String dirName = "";
        String parName = parent;
        int idx = parName.lastIndexOf("/");
        if (idx != -1) {
            dirName = parName.substring(idx + 1);
            parName = parName.substring(0, idx);
        } else if (idx == -1) {
            dirName = parName;
        }
        return dirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean process(File directory, Hashtable table, Collection col) throws Exception {
        try {
            String[] files;
            String collection;
            String[] list;
            block15: {
                list = null;
                collection = (String)table.get("collection");
                String colstring = this.normalizeCollectionURI((String)table.get("collection"), (String)table.get("local"));
                col = DatabaseManager.getCollection((String)colstring);
                if (col == null) {
                    System.out.println("ERROR : Collection not found!");
                    boolean bl = false;
                    return bl;
                }
                files = null;
                try {
                    files = col.listResources();
                }
                catch (XMLDBException e) {
                    if (e.errorCode == 1) break block15;
                    throw e;
                }
            }
            if (files != null) {
                System.out.println("Extracting " + files.length + " files from " + table.get("collection"));
                for (int j = 0; j < files.length; ++j) {
                    Resource res = col.getResource(files[j]);
                    Object content = res.getContent();
                    FileOutputStream output = new FileOutputStream(new File(directory, files[j]));
                    try {
                        if (content instanceof String) {
                            output.write(((String)content).getBytes("utf-8"));
                            continue;
                        }
                        output.write((byte[])content);
                        continue;
                    }
                    finally {
                        output.close();
                    }
                }
            }
            list = col.listChildCollections();
            for (int i = 0; i < list.length; ++i) {
                File file = new File(directory, list[i]);
                System.out.println("Creating directory " + file.getPath());
                file.mkdirs();
                table.put("collection", collection + "/" + file.getName());
                this.process(new File(directory + "//" + file.getName()), table, col);
            }
        }
        finally {
            if (col != null) {
                col.close();
            }
        }
        return true;
    }
}

