package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;

import jp.crestmuse.cmx.amusaj.filewrappers.StringElement;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.misc.QueueReader;

public class ChordPredictorModule extends
    SPModule<MidiEventWithTicktime, StringElement> {

  private ChordPredictable predictor;

  public ChordPredictorModule(ChordPredictable predictor) {
    this.predictor = predictor;
  }

  public void execute(List<QueueReader<MidiEventWithTicktime>> src,
      List<TimeSeriesCompatible<StringElement>> dest)
      throws InterruptedException {
    MidiEventWithTicktime w = src.get(0).take();
    dest.get(0).add(predictor.predictNextChord(w));
  }

  public int getInputChannels() {
    return 1;
  }

  public int getOutputChannels() {
    return 1;
  }
/*
  public static void main(String[] args) {
    try {
      MIDIXMLWrapper midi = MIDIXMLWrapper.readSMF(args[0]);
      MutableMIDIEventWrapperSeries input = SMF2MIDIEventWrapperSeries(midi);
      ChordPredictor predictor = new ChordPredictor(
          new BayesNetWrapper(args[1]), midi.ticksPerBeat());
      ChordPredictorModule npm = new ChordPredictorModule(input, predictor);
      SPExecutor sp = new SPExecutor(null, input.frames(), 0);
      sp.addSPModule(npm);
      sp.start();
      for (TimeSeriesCompatible<MIDIEventWrapper> tsc : sp.getResult(npm)) {
        for (MIDIEventWrapper m : tsc.getQueueReader()) {
          System.out.println(m);
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static MutableMIDIEventWrapperSeries SMF2MIDIEventWrapperSeries(
      MIDIXMLWrapper midi) {
    try {
      LinkedList<MIDIEventWrapper> inputlist = new LinkedList<MIDIEventWrapper>();
      for (Track track : midi.getTrackList()) {
        for (MIDIEvent event : track.getMIDIEventList()) {
          if (event.messageType().equals("NoteOn")
              || event.messageType().equals("NoteOff")) {
            MIDIEventWrapper w = new MIDIEventWrapper(event, "");
            inputlist.add(w);
          }
        }
      }
      MutableMIDIEventWrapperSeries result = new MutableMIDIEventWrapperSeries(
          inputlist.size(), 0);
      for (MIDIEventWrapper m : inputlist)
        result.add(m);
      return result;
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
*/
}
