/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chord {
    private String name;
    private ArrayList<Integer> notes = new ArrayList();
    private int inversion = 0;
    private int basenote = 48;
    public String NAMELESS = "noname";

    public Chord(int ... nArray) {
        this.setNoteList(nArray);
        this.name = this.NAMELESS;
        this.inversion = 0;
    }

    public Chord(String string, int n) {
        this.name = string;
        if (n != 0) {
            this.invertChord(n);
        } else {
            this.inversion = 0;
        }
    }

    public Chord(String string) throws RuntimeException {
        if (string.equals("C")) {
            this.setNoteList(48, 52, 55);
        } else if (string.equals("Dm")) {
            this.setNoteList(50, 53, 57);
        } else if (string.equals("Em")) {
            this.setNoteList(52, 55, 59);
        } else if (string.equals("F")) {
            this.setNoteList(53, 57, 60);
        } else if (string.equals("G")) {
            this.setNoteList(55, 59, 62);
        } else if (string.equals("Am")) {
            this.setNoteList(57, 60, 64);
        } else if (string.equals("Bm(b5)")) {
            this.setNoteList(59, 62, 65);
        } else {
            throw new RuntimeException("It is note Diatonic Chord.");
        }
        this.name = string;
        this.inversion = 0;
    }

    public void invertChord(int n) {
        this.sortNotes(this.notes);
        if (n != 0) {
            if (n > 0) {
                this.notes.set(0, this.notes.get(0) + 12);
                this.sortNotes(this.notes);
                ++this.inversion;
                this.invertChord(n - 1);
            } else if (n < 0) {
                this.notes.set(this.notes.size() - 1, this.notes.get(this.notes.size() - 1) - 12);
                this.sortNotes(this.notes);
                --this.inversion;
                this.invertChord(n + 1);
            }
        }
    }

    public boolean isInverted() {
        return this.inversion != 0;
    }

    public int getBaseNote() {
        return this.basenote;
    }

    public void setBaseNote(int n) throws RuntimeException {
        if (n % 12 != 0 || n < 0 || 128 < n) {
            throw new RuntimeException("BaseNote\u306f12\u306e\u500d\u6570\u3067\u304b\u3064Midi\u30ce\u30fc\u30c8\u30ca\u30f3\u30d0\u30fc\u306e\u7bc4\u56f2\u5185\u3067\u306a\u3051\u308c\u3070\u3044\u3051\u307e\u305b\u3093");
        }
        this.basenote = n;
    }

    public String getChordName() {
        return this.name;
    }

    public ArrayList<Integer> getNotesList() {
        return this.notes;
    }

    public String toString() {
        String string = new String();
        for (int n : this.notes) {
            string = string + n;
            if (this.notes.size() - 1 == this.notes.lastIndexOf(n)) continue;
            string = string + ",";
        }
        return string;
    }

    public void printNotes() {
        System.out.println(this.toString());
    }

    public void printChordStats() {
        System.out.println(this.name + ":" + this.toString() + " Inv:" + this.inversion + " Base:" + this.basenote);
    }

    private void setNoteList(int ... nArray) {
        for (int n : nArray) {
            this.notes.add(n);
        }
    }

    private void sortNotes(ArrayList<Integer> arrayList) {
        Collections.sort(arrayList);
    }

    public static void main(String[] stringArray) {
        Chord chord = new Chord("C");
        chord.printChordStats();
        chord.invertChord(2);
        chord.printChordStats();
        chord.invertChord(-2);
        chord.printChordStats();
    }
}

