/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.BooleanArrayFactory;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.DoubleMatrixFactory;

public class Utils {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final BooleanArrayFactory bfactory = BooleanArrayFactory.getFactory();
    private static final DoubleMatrixFactory mfactory = DoubleMatrixFactory.getFactory();

    private Utils() {
    }

    public static DoubleArray cloneArray(DoubleArray doubleArray) {
        try {
            return (DoubleArray)doubleArray.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            int n = doubleArray.length();
            DoubleArray doubleArray2 = factory.createArray(n);
            for (int i = 0; i < n; ++i) {
                doubleArray2.set(i, doubleArray.get(i));
            }
            return doubleArray2;
        }
    }

    public static String toString(DoubleArray doubleArray, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        int n = doubleArray.length();
        if (n >= 1) {
            stringBuilder.append(String.valueOf(doubleArray.get(0)));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(doubleArray.get(i)));
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String toString1(DoubleArray doubleArray) {
        return Utils.toString(doubleArray, ", ", "{", "}");
    }

    public static String toString2(DoubleArray doubleArray) {
        return Utils.toString(doubleArray, " ", "", "");
    }

    public static String toString(ComplexArray complexArray, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        int n = complexArray.length();
        if (n >= 1) {
            stringBuilder.append(String.valueOf(complexArray.getReal(0))).append(" + ");
            stringBuilder.append(String.valueOf(complexArray.getImag(0))).append(" i");
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(complexArray.getReal(i))).append(" + ");
                stringBuilder.append(String.valueOf(complexArray.getImag(i))).append(" i");
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String toString(ComplexArray complexArray) {
        return Utils.toString(complexArray, ", ", "{", "}");
    }

    public static String toString2(ComplexArray complexArray) {
        return Utils.toString(complexArray, " ", "", "");
    }

    public static String toString(DoubleMatrix doubleMatrix, String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        int n = doubleMatrix.nrows();
        if (n >= 1) {
            Utils.appendRowString(doubleMatrix, 0, string, stringBuilder);
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string2);
                Utils.appendRowString(doubleMatrix, 0, string, stringBuilder);
            }
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private static void appendRowString(DoubleMatrix doubleMatrix, int n, String string, StringBuilder stringBuilder) {
        int n2 = doubleMatrix.ncols();
        if (n2 >= 1) {
            stringBuilder.append(String.valueOf(doubleMatrix.get(n, 0)));
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(doubleMatrix.get(n, i)));
            }
        }
    }

    public static String toString1(DoubleMatrix doubleMatrix) {
        return Utils.toString(doubleMatrix, ", ", ";\n", "{", "}");
    }

    public static String toString2(DoubleMatrix doubleMatrix) {
        return Utils.toString(doubleMatrix, " ", "\n", "", "");
    }

    public static DoubleArray parseArray(String string, String string2) {
        String[] stringArray = string.trim().split(string2);
        int n = stringArray.length;
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, Double.parseDouble(stringArray[i]));
        }
        return doubleArray;
    }

    public static DoubleArray parseArray(String string) {
        return Utils.parseArray(string, " ");
    }

    public static DoubleMatrix parseMatrix(String string, String string2, String string3) {
        String[] stringArray = string.trim().split(string3);
        int n = stringArray.length;
        int n2 = stringArray[0].trim().split(string2).length;
        DoubleMatrix doubleMatrix = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(string2);
            if (n2 != stringArray2.length) {
                throw new IllegalStateException("inconsistent data size");
            }
            for (int j = 0; j < n2; ++j) {
                doubleMatrix.set(i, j, Double.parseDouble(stringArray2[j]));
            }
        }
        return doubleMatrix;
    }

    public static DoubleMatrix parseMatrix(String string) {
        return Utils.parseMatrix(string, " ", "\n");
    }
}

