/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPDummyObject;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.sound.TickTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiInputModule
extends SPModule<SPDummyObject, MidiEventWithTicktime>
implements Receiver {
    private TickTimer tt;
    private Transmitter tm;
    private MidiDevice input_device;
    private BlockingQueue<MidiEventWithTicktime> src_queue = new LinkedBlockingQueue<MidiEventWithTicktime>();

    public MidiInputModule(MidiDevice midiDevice) throws MidiUnavailableException {
        this(null, midiDevice);
    }

    public MidiInputModule(TickTimer tickTimer, MidiDevice midiDevice) throws MidiUnavailableException {
        this.tt = tickTimer;
        this.input_device = midiDevice;
        this.input_device.open();
        this.tm = this.input_device.getTransmitter();
        this.tm.setReceiver(this);
    }

    public void setTickTimer(TickTimer tickTimer) {
        this.tt = tickTimer;
    }

    @Override
    public void execute(List<QueueReader<SPDummyObject>> list, List<TimeSeriesCompatible<MidiEventWithTicktime>> list2) throws InterruptedException {
        list2.get(0).add((MidiEventWithTicktime)((SPElement)this.src_queue.take()));
    }

    @Override
    public int getInputChannels() {
        return 0;
    }

    @Override
    public int getOutputChannels() {
        return 1;
    }

    @Override
    public void close() {
        this.tm.close();
        this.input_device.close();
    }

    @Override
    public void send(MidiMessage midiMessage, long l) {
        long l2 = -1L;
        if (this.tt != null) {
            l2 = this.tt.getTickPosition();
        }
        MidiEventWithTicktime midiEventWithTicktime = new MidiEventWithTicktime(midiMessage, l, l2);
        this.src_queue.add(midiEventWithTicktime);
    }
}

