/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;

public class ArffWrapper
implements FileWrapperCompatible {
    private String fileName = null;
    private String relation;
    private LinkedList<Attribute> attributelist;
    private LinkedList<String> datalist;

    public ArffWrapper(String string) {
        this.relation = string;
        this.attributelist = new LinkedList();
        this.datalist = new LinkedList();
    }

    public void addAttribute(String string, String[] stringArray) {
        this.attributelist.add(new Attribute(string, stringArray));
    }

    public void addData(String string) {
        this.datalist.add(string);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void write(OutputStream outputStream) throws IOException, SAXException {
        outputStream.write(("@relation " + this.relation + System.getProperty("line.separator") + System.getProperty("line.separator")).getBytes());
        for (Attribute object : this.attributelist) {
            outputStream.write((object.toString() + System.getProperty("line.separator")).getBytes());
        }
        outputStream.write((System.getProperty("line.separator") + "@data" + System.getProperty("line.separator")).getBytes());
        for (String string : this.datalist) {
            outputStream.write((string + System.getProperty("line.separator")).getBytes());
        }
    }

    public void write(Writer writer) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    public void writefile(File file) throws IOException, SAXException {
        this.write(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public void writeGZippedFile(File file) throws IOException, SAXException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    class Attribute {
        private String name;
        private boolean isNominal;
        private String[] nominals;
        private double numeric;

        Attribute(String string, String[] stringArray) {
            this.name = string;
            this.nominals = stringArray;
            this.isNominal = true;
        }

        Attribute(String string, double d) {
            this.name = string;
            this.numeric = d;
            this.isNominal = false;
        }

        public String toString() {
            String string = "@attribute " + this.name + " ";
            if (this.isNominal) {
                string = string + "{";
                for (String string2 : this.nominals) {
                    string = string + string2 + ", ";
                }
                string = string + "}";
            } else {
                string = string + this.numeric;
            }
            return string;
        }
    }
}

