/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.ChordConverter;
import jp.crestmuse.cmx.amusaj.filewrappers.BayesNetWrapper;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;

public class BayesInferenceChecker080731 {
    private BayesNetWrapper bnw;
    private int totalTrial = 0;
    private int totalCorrect = 0;
    private int totalDiatonic = 0;
    private int totalInf2 = 0;
    private int totalInf3 = 0;
    private int totalFailed = 0;
    private int totalSamePrefix = 0;

    public BayesInferenceChecker080731(String string) {
        this.bnw = new BayesNetWrapper(string);
    }

    public void checkSCCXML(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            int n8;
            SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.readfile(string);
            ChordConverter chordConverter = new ChordConverter();
            String string2 = "UNDEFINED";
            for (n8 = 0; n8 < sCCXMLWrapper.getHeaderElementList().length; ++n8) {
                if (!sCCXMLWrapper.getHeaderElementList()[n8].name().equals("KEY")) continue;
                string2 = chordConverter.getPrefix(sCCXMLWrapper.getHeaderElementList()[n8].content());
                break;
            }
            if (string2.equals("UNDEFINED")) {
                System.out.println(string + " is invalid musickey");
                return;
            }
            n8 = -1;
            String string3 = null;
            int n9 = -1;
            String string4 = null;
            for (SCCXMLWrapper.Annotation annotation : sCCXMLWrapper.getChordList()) {
                String string5 = annotation.content();
                int n10 = -1;
                for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                    if (note.onset() < annotation.onset()) continue;
                    n10 = note.notenum() % 12;
                    break;
                }
                if (n10 == -1) continue;
                if ((string5 = chordConverter.chordOmitter(chordConverter.chordTransfer(string2, string5))).equals("/")) {
                    string5 = string4;
                }
                n10 = chordConverter.noteTransfer(string2, n10);
                if (string4 != null && n10 != -1 && string3 != null) {
                    this.bnw.setEvidence(0, n8);
                    this.bnw.setEvidence(1, string3);
                    this.bnw.setEvidence(2, n9);
                    this.bnw.setEvidence(3, string4);
                    this.bnw.update();
                    ++n;
                    String string6 = this.bnw.getHighestMarginName(5);
                    String string7 = this.bnw.getRankedMarginName(5, 2);
                    String string8 = this.bnw.getRankedMarginName(5, 3);
                    System.out.println("ppN:" + n8 + "  ppC:" + string3 + "  pN:" + n9 + "  pC:" + string4 + "  (Fact: " + string5 + "  Inf:" + string6 + ")  Follows:" + string7 + " " + string8);
                    if (string5.equals(string6)) {
                        ++n2;
                    } else {
                        ++n6;
                        if (string5.equals(string7)) {
                            ++n4;
                        } else if (string5.equals(string8)) {
                            ++n5;
                        }
                        if (chordConverter.getPrefix(string5).equals(chordConverter.getPrefix(string6))) {
                            ++n7;
                        }
                    }
                    if (chordConverter.isDiatonic(string6)) {
                        ++n3;
                    }
                }
                n8 = n9;
                n9 = -1;
                for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                    if (note.onset() >= annotation.offset()) break;
                    n9 = note.notenum();
                }
                if (n9 == -1) continue;
                n9 %= 12;
                string3 = string4;
                string4 = string5;
            }
            this.totalTrial += n;
            this.totalCorrect += n2;
            this.totalDiatonic += n3;
            this.totalInf2 += n4;
            this.totalInf3 += n5;
            this.totalFailed += n6;
            this.totalSamePrefix += n7;
            System.out.println(string + " -- Trial :" + n + "\tCorrect: " + n2 + "\tFailed: " + n6 + "\tinDiatonic: " + n3 + "  (Match2nd: " + n4 + "  Match3rd: " + n5 + "  SamePrefix: " + n7 + ")\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printTotalCounter() {
        System.out.println("----------- TOTAL ---------");
        System.out.println("Trial: " + this.totalTrial + "\tCorrect: " + this.totalCorrect + "\tFailed: " + this.totalFailed + "\tinDiatonic: " + this.totalDiatonic + "\n(Match2nd: " + this.totalInf2 + "  Match3rd: " + this.totalInf3 + "  SamePrefix: " + this.totalSamePrefix + ")");
        System.out.println("SuccessRate: " + (double)this.totalCorrect / (double)this.totalTrial * 100.0 + " %" + "\tinDiatonicRate:" + (double)this.totalDiatonic / (double)this.totalTrial * 100.0 + " %" + "\tMatch in 3rd Range: " + (double)(this.totalCorrect + this.totalInf2 + this.totalInf3) / (double)this.totalTrial * 100.0 + "%");
    }

    public static void main(String[] stringArray) {
        String string = "080731model.bif";
        BayesInferenceChecker080731 bayesInferenceChecker080731 = new BayesInferenceChecker080731(string);
        System.out.println("--- " + string + " loaded. ---");
        bayesInferenceChecker080731.checkSCCXML("funkyxml//sample020.xml");
        bayesInferenceChecker080731.checkSCCXML("funkyxml//sample040.xml");
        bayesInferenceChecker080731.checkSCCXML("funkyxml//sample060.xml");
        bayesInferenceChecker080731.checkSCCXML("funkyxml//sample080.xml");
        bayesInferenceChecker080731.checkSCCXML("funkyxml//sample100.xml");
        bayesInferenceChecker080731.printTotalCounter();
    }
}

