/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jp.crestmuse.cmx.misc.MIDIConst;

public class MIDIEventList
implements Iterable<MIDIEvent> {
    private SortedSet<MIDIEvent> s = new TreeSet<MIDIEvent>(new Comparator<MIDIEvent>(){

        @Override
        public int compare(MIDIEvent mIDIEvent, MIDIEvent mIDIEvent2) {
            return mIDIEvent.time == mIDIEvent2.time ? (mIDIEvent.status == mIDIEvent2.status ? (mIDIEvent.ch == mIDIEvent2.ch ? (mIDIEvent.value1 == mIDIEvent2.value1 ? mIDIEvent.value2 - mIDIEvent2.value2 : mIDIEvent.value1 - mIDIEvent2.value1) : mIDIEvent.ch - mIDIEvent2.ch) : mIDIEvent.status - mIDIEvent2.status) : mIDIEvent.time - mIDIEvent2.time;
        }
    });

    public void addEvent(int n, String string, byte by, int n2, int n3) {
        this.s.add(new MIDIEvent(n, string, by, n2, n3));
    }

    public void addEvent(int n, short s, byte by, int n2, int n3) {
        this.s.add(new MIDIEvent(n, s, by, n2, n3));
    }

    @Override
    public Iterator<MIDIEvent> iterator() {
        return this.s.iterator();
    }

    public final class MIDIEvent {
        private int time;
        private int value1 = 0;
        private int value2 = 0;
        private short status;
        private String msgname;
        private byte ch;

        MIDIEvent(int n, short s, byte by, int n2, int n3) {
            this.time = n;
            this.status = s;
            this.value1 = n2;
            this.value2 = n3;
            this.msgname = MIDIConst.statusNoToMsgName(s);
            this.ch = by;
        }

        MIDIEvent(int n, String string, byte by, int n2, int n3) {
            this.time = n;
            this.msgname = string;
            this.value1 = n2;
            this.value2 = n3;
            this.status = MIDIConst.msgNameToStatusNo(string);
            this.ch = by;
        }

        public final int time() {
            return this.time;
        }

        public final short status() {
            return this.status;
        }

        public final String msgname() {
            return this.msgname;
        }

        public final byte channel() {
            return this.ch;
        }

        public final int value1() {
            return this.value1;
        }

        public final int value2() {
            return this.value2;
        }
    }
}

