%-*-Mode:erlang;coding:utf-8;tab-width:4;c-basic-offset:4;indent-tabs-mode:()-*-
% ex: set ft=erlang fenc=utf-8 sts=4 ts=4 sw=4 et nomod:
%%%
%%%------------------------------------------------------------------------
%%% @doc
%%% ==Supervisor Test Server==
%%% @end
%%%
%%% MIT License
%%%
%%% Copyright (c) 2015-2021 Michael Truog <mjtruog at protonmail dot com>
%%%
%%% Permission is hereby granted, free of charge, to any person obtaining a
%%% copy of this software and associated documentation files (the "Software"),
%%% to deal in the Software without restriction, including without limitation
%%% the rights to use, copy, modify, merge, publish, distribute, sublicense,
%%% and/or sell copies of the Software, and to permit persons to whom the
%%% Software is furnished to do so, subject to the following conditions:
%%%
%%% The above copyright notice and this permission notice shall be included in
%%% all copies or substantial portions of the Software.
%%%
%%% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
%%% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
%%% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
%%% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
%%% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
%%% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
%%% DEALINGS IN THE SOFTWARE.
%%%
%%% @author Michael Truog <mjtruog at protonmail dot com>
%%% @copyright 2015-2021 Michael Truog
%%% @version 2.0.2 {@date} {@time}
%%%------------------------------------------------------------------------

-module(cloudi_x_supool_test_server).
-author('mjtruog at protonmail dot com').

%% external interface
-export([start_link/0,
         ping/1]).

%%%------------------------------------------------------------------------
%%% External interface functions
%%%------------------------------------------------------------------------

start_link() ->
    {ok, erlang:spawn_link(fun loop/0)}.

ping(Pid) ->
    Pid ! {self(), ping},
    receive
        pong ->
            pong
    after
        5000 ->
            pang
    end.

%%%------------------------------------------------------------------------
%%% Private functions
%%%------------------------------------------------------------------------

loop() ->
    receive
        {Pid, ping} ->
            Pid ! pong
    end,
    loop().

-ifdef(TEST).
-include_lib("eunit/include/eunit.hrl").

-ifdef(CLOUDI_TEST_TIMEOUT).
-define(TEST_TIMEOUT, ?CLOUDI_TEST_TIMEOUT). % seconds
-else.
-define(TEST_TIMEOUT, 10). % seconds
-endif.

module_test_() ->
    {timeout, ?TEST_TIMEOUT, [
        {"internal tests", ?_assertEqual(ok, t_basic())}
    ]}.

t_basic() ->
    application:start(cloudi_x_supool),
    ChildSpec = {undefined, {cloudi_x_supool_test_server, start_link, []},
                 permanent, brutal_kill, worker, [cloudi_x_supool_test_server]},
    {ok, Supervisor} = cloudi_x_supool:start_link(group_0, 2, ChildSpec),
    erlang:unlink(Supervisor),
    Child0 = cloudi_x_supool:get(group_0),
    Child1 = cloudi_x_supool:get(group_0),
    true = (Child0 /= Child1),
    true = is_pid(Child0),
    true = is_pid(Child1),
    pong = cloudi_x_supool_test_server:ping(Child0),
    pong = cloudi_x_supool_test_server:ping(Child1),
    erlang:exit(Child0, kill),
    Child1 = cloudi_x_supool:get(group_0),
    Child0New = cloudi_x_supool:get(group_0),
    true = (Child0 /= Child0New),
    true = is_pid(Child0New),
    erlang:exit(erlang:whereis(group_0), kill),
    receive after 500 -> ok end,
    Child0New = cloudi_x_supool:get(group_0),
    Child1 = cloudi_x_supool:get(group_0),
    Child0New = cloudi_x_supool:get(group_0),
    [{2, Child1, _, _},
     {1, Child0New, _, _},
     {cloudi_x_supool, _, _, _}] = supervisor:which_children(Supervisor),
    [Child0New, Child1] = cloudi_x_supool_sup:which_children(Supervisor),
    erlang:exit(Supervisor, shutdown),
    ok.

-endif.
