void makegraph( const TString& f )
{
  gROOT->Reset();
  gStyle->SetOptDate();

  // event and arrow, don't arrow wrong format
  TString eventdate[] = {
    "2003-07-08", "2nd BEAMTEST",
    "2003-07-17", "v1.6.0 release",
    //"2003-07-31", "v1.7.0 release",
    "2003-09-07", "v1.8.0 release",
    "2003-10-15", "3rd BEAMTEST",
    "2003-11-03", "v1.10.0 release",
    "2003-12-09", "v1.11.0 release",  // added on 2002-12-26

    "" };
  //////////////////////////////////////////////


  // buffers
  const size_t maxlen = 0x10000;
  TString date[maxlen];
  int x[maxlen];
  double y[maxlen];
  double ysum[maxlen];


  // Read from log
  ifstream ifs(f.Data());
  int n=0;

  while ( ifs>>date[n]>>y[n] ) {
    TString sqlDateTime = date[n] + " 00:00:01";
    TDatime dt(sqlDateTime.Data());
    x[n]=dt.Convert();

    if ( n > 0 ) {
      ysum[n] = y[n] + ysum[n-1];
    } else if ( n == 0 ) {
      ysum[n] = y[n];
    }

    n++;
  }
  ifs.close();


  // byte->Kbyte
  for ( int i = 0; i < n; i ++ ) {
    y[i]/=1024.0;
    ysum[i]/=1024.0;
  }


  // Second -> Day
  //  one bin = 1 day
  double bintime = 60*60*24;
  const int firstday = x[0];
  x[0] = 0;
  for ( int i = 1; i < n; i ++ ) {
    x[i]-=firstday;
    x[i]/=bintime;
  }
  gStyle->SetTimeOffset(firstday);





  cv = new TCanvas("cv","ChangeLog Progress");
  cv -> ToggleEventStatus();
  cv -> SetFillColor(21);
  cv -> SetFillStyle(1001);
  cv -> SetGridx();
  cv -> SetGridy();
  cv -> SetTopMargin(0.18);

  //h = new TH1D("h","",10,0.0,10.0*bintime);
  int dayinit = 250;
  h = new TH1D("h","",dayinit,0.0,dayinit*bintime);
  h -> SetLineColor(kBlue);
  h -> SetFillColor(38);
  h -> SetFillStyle(1001);
  h -> SetStats(kFALSE);
  TAxis* yaxis = h->GetYaxis();
  yaxis->SetTitle("ChangeLog (KByte)");
  //yaxis->SetTitleColor(kBlue);
  yaxis->CenterTitle();
  xaxis = h -> GetXaxis();
  xaxis->SetTimeDisplay(kTRUE);
  //xaxis-> SetTitle( "" );
  xaxis-> CenterTitle();



  hsum = new TH1D("hsum","",10,0.0,10.0*bintime);
  hsum->GetXaxis()->SetTimeDisplay(kTRUE);
  hsum -> SetStats(kFALSE);

  for ( int i = 0; i < n; i ++ ) {
    h -> SetBinContent(x[i],y[i]);
    hsum -> SetBinContent(x[i],ysum[i]);
  }

  h->GetXaxis()->SetTimeFormat("%y/%m/%d");
  h -> Draw();
  cv->Update();



  double rightmax = 1.1*(hsum->GetMaximum());
  double scale = (gPad->GetUymax())/rightmax;
  hsum -> SetMarkerColor(46);
  hsum -> SetMarkerStyle(21);
  hsum -> SetMarkerSize(0.8);
  hsum -> Scale(scale);
  hsum -> Draw("samep");

  axis = new TGaxis(gPad->GetUxmax(),gPad->GetUymin(),
                    gPad->GetUxmax(), gPad->GetUymax(),0,rightmax,510,"+L");
  axis->SetTitle("Total ChangeLog (KByte)");
  //axis->SetTextColor(kRed);
  axis->SetMaxDigits(2);
  axis->CenterTitle();
  axis->Draw();


  leg = new TLegend( 0.12, 0.70, 0.88, 0.78 );
  leg -> SetBorderSize(0);
  leg -> SetFillColor(0);
  leg -> SetFillStyle(0);
  leg->SetName( "leg" );
  leg->SetMargin(0.2);
  leg->SetMargin(0.1);
  leg->AddEntry(h,   "Size of ChangeLog in KByte (Left Hand Scale)","f");
  leg->AddEntry(hsum,"Statistics in KByte (Right Hand Scale)","p");
  leg->Draw();




  //==============================================================
  // EVENT & ARROW DRAW
  int nevent = 0;
  TString ev[maxlen];
  int evd[maxlen];
  while ( eventdate[nevent] != "" ) {
    TString sqlDateTime = eventdate[nevent] + " 00:00:01";
    TDatime dt(sqlDateTime.Data());
    evd[nevent/2]=(dt.Convert()-firstday)/bintime;
    ev[nevent/2]=eventdate[nevent+1];
    nevent +=2;
  }
  nevent/=2;

  const double binw = h->GetBinWidth(0);
  const double framew = binw*(h->GetNbinsX());
  const double ftop=cv->GetFrame()->GetY2();
  const double frameh=ftop-(cv->GetFrame()->GetY1());
  double x1[maxlen];
  double x2[maxlen];
  double y1[maxlen];
  double y2[maxlen];
  const double fx=0.04;
  const double fy=0.06;
  for (int i =0;i<nevent;i++) {
    x2[i]=binw*evd[i];
    y2[i]=ftop;

    int ff= i%2+1;
    x1[i]=x2[i]+(framew*fx*ff);
    y1[i]=y2[i]+(frameh*fy*ff);
  }

  for (int i=0;i<nevent;i++) {
    ar = new TArrow(x1[i],y1[i],x2[i],y2[i],0.02,"|>");
    ar->SetLineColor(1);
    ar->SetLineStyle(1);
    ar->SetLineWidth(1);
    ar->SetFillColor(10);
    ar->SetFillStyle(1001);
    ar->Draw();

    
    tex=new TLatex(x1[i],y1[i],ev[i].Data());
    tex->SetTextSize(0.032);
    if ( i%2 == 0 ) {
      //tex->SetTextColor(49);
      tex->SetTextColor(46);
    } else {
      tex->SetTextColor(38);
    }
    tex->Draw();
  }
  //==============================================================





  //
  h->GetXaxis() -> SetNdivisions( 508 );
  //
  cv->GetFrame()->SetFillStyle(1001);
  cv->GetFrame()->SetFillColor(17);
  cv->Modified();
  cv->Update();

  //cv->Print(getpsname().Data());
  cv->Print("ChangeLog.ps");
  gSystem->Exec("convert -rotate 90 -crop 0x0 ChangeLog.ps ChangeLog.png");
  gSystem->Exec("convert -geometry 198 -border 1x1 -bordercolor \"#888888\" ChangeLog.png ChangeLog_w200.png");

}

TString getpsname()
{
  TDatime dt;
  char buf[ 16 ];
  sprintf( buf, "%.8d", dt.GetDate() );
  TString psf = "log";
  psf = psf + buf + ".ps";

  return psf.Data();
}
