/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import jp.co.ogis_ri.citk.common.exception.IllegalRequestException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.util.StringUtils;

public class RequestParameterTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(RequestParameterTransformer.class);
    private RequestParameterCache cache = null;

    public RequestParameterCache getCache() {
        return this.cache;
    }

    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage originalMessage = null;
        String relayState = (String)message.getInboundProperty("RelayState");
        if (relayState != null) {
            originalMessage = this.cache.get(relayState);
            if (originalMessage == null) {
                throw new IllegalRequestException("E-0002", message, new Object[0]);
            }
            this.cache.remove(relayState);
        } else {
            originalMessage = message;
        }
        for (String name : originalMessage.getInboundPropertyNames()) {
            Object inValue = originalMessage.getInboundProperty(name);
            if (inValue == null || name.equals("Accept-Encoding")) continue;
            if (name.equals("http.request")) {
                String path = this.deleteUrlParam((String)inValue, "idpEntityId");
                path = this.deleteUrlParam(path, "RelayState");
                path = this.deleteUrlParam(path, "authz");
                message.setOutboundProperty(name, (Object)path);
                continue;
            }
            message.setOutboundProperty(name, inValue);
        }
        message.setOutboundProperty("cookies", message.getInboundProperty("cookies"));
        message.setPayload(originalMessage.getPayload());
        return message;
    }

    protected String deleteUrlParam(String url, String key) {
        logger.debug("url : {0}, query key : {1} ", new Object[]{url, key});
        if (StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)key)) {
            return url;
        }
        StringBuilder returnUrl = new StringBuilder(url);
        int st = url.indexOf("?");
        if (st >= 0) {
            String queryString = url.substring(st + 1);
            returnUrl = new StringBuilder(url.substring(0, st));
            String[] params = queryString.split("&");
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                if (param.startsWith(key + "=")) continue;
                if (returnUrl.indexOf("?") < 0 && !returnUrl.toString().endsWith("?")) {
                    returnUrl.append("?");
                } else if (!returnUrl.toString().endsWith("&")) {
                    returnUrl.append("&");
                }
                returnUrl.append(param);
            }
        }
        return returnUrl.toString();
    }
}

