/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import java.util.Date;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;
import org.apache.commons.httpclient.Cookie;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;

public class RedirectionTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(RedirectionTransformer.class);
    private String requestProtocol = null;
    private RequestParameterCache cache = null;
    private String domain = null;
    private String idpAuthnCookieName = null;

    public String getRequestProtocol() {
        return this.requestProtocol;
    }

    public void setRequestProtocol(String requestProtocol) {
        this.requestProtocol = requestProtocol;
    }

    public RequestParameterCache getCache() {
        return this.cache;
    }

    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getIdpAuthnCookieName() {
        return this.idpAuthnCookieName;
    }

    public void setIdpAuthnCookieName(String idpAuthnCookieName) {
        this.idpAuthnCookieName = idpAuthnCookieName;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String acsStatus = (String)message.getOutboundProperty("citk.acs.status");
        String location = null;
        if (acsStatus == null) {
            location = (String)message.getInboundProperty("Location");
        } else if (acsStatus.equals("ok")) {
            String relayState = (String)message.getSessionProperty("citk.relaystate");
            MuleMessage originalMessage = this.cache.get(relayState);
            location = this.buildLocation(originalMessage, relayState);
        } else if (acsStatus.equals("ng")) {
            this.clearAuthnCookies(message);
            location = (String)message.getInboundProperty("Location");
            String relayState = (String)message.getSessionProperty("citk.relaystate");
            location = location.contains("?") ? location + "&" + "RelayState" + "=" + relayState : location + "?" + "RelayState" + "=" + relayState;
        } else {
            throw new CitkSystemException("acsStatus\u306b\u4e0d\u6b63\u306a\u5024\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059", message);
        }
        if (location == null) {
            throw new CitkSystemException("\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u5148Location\u304cNULL\u3067\u3059", message);
        }
        message.setOutboundProperty("http.status", (Object)302);
        message.setOutboundProperty("Location", (Object)location);
        logger.debug("acs status: " + acsStatus, new Object[0]);
        logger.debug("location: " + location, new Object[0]);
        return message;
    }

    private String buildLocation(MuleMessage originalMessage, String relayState) {
        String host = (String)originalMessage.getInboundProperty("Host");
        String path = (String)originalMessage.getInboundProperty("http.request.path");
        String location = this.requestProtocol + host + path + "?" + "RelayState" + "=" + relayState;
        return location;
    }

    private void clearAuthnCookies(MuleMessage message) {
        String dummyValue = "";
        Date deleteExpire = new Date(0L);
        int cookiesNum = 4;
        Boolean isTimeOut = null;
        isTimeOut = (Boolean)message.getSessionProperty("citk.isTimeOut");
        if (isTimeOut != null && isTimeOut.booleanValue()) {
            cookiesNum = 5;
        }
        Cookie[] cookies = new Cookie[cookiesNum];
        block7: for (int i = 0; i < cookiesNum; ++i) {
            switch (i) {
                case 0: {
                    cookies[i] = new Cookie(this.domain, "nameId", dummyValue, "/", deleteExpire, false);
                    continue block7;
                }
                case 1: {
                    cookies[i] = new Cookie(this.domain, "idpEntityId", dummyValue, "/", deleteExpire, false);
                    continue block7;
                }
                case 2: {
                    cookies[i] = new Cookie(this.domain, "expire", dummyValue, "/", deleteExpire, false);
                    continue block7;
                }
                case 3: {
                    cookies[i] = new Cookie(this.domain, "accessDate", dummyValue, "/", deleteExpire, false);
                    continue block7;
                }
                case 4: {
                    cookies[i] = new Cookie(this.domain, this.idpAuthnCookieName, dummyValue, "/", deleteExpire, false);
                    continue block7;
                }
            }
        }
        message.setProperty("Set-Cookie", (Object)cookies, PropertyScope.INBOUND);
    }
}

