/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.wsp.cxf.jaxws.handler;

import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

public abstract class AbstractWsHandler {
    private static CitkLogger logger = CitkLogger.getLog(AbstractWsHandler.class);
    private static final String WSS_SHARED_MAP = "WSS_SHARED_MAP";
    protected SOAPRequestHandlerInterface requestHandler;
    private String wspProfile;

    public void handleMessage(SoapMessage message, ThreadLocal<Subject> cred, Subject subject) throws Fault {
        SOAPMessageContextImpl context = new SOAPMessageContextImpl((Message)message);
        HashMap<Object, Object> sharedMap = (HashMap<Object, Object>)context.get((Object)WSS_SHARED_MAP);
        if (sharedMap == null || sharedMap.isEmpty()) {
            sharedMap = new HashMap<Object, Object>();
            context.put((Object)WSS_SHARED_MAP, sharedMap);
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("providername", this.wspProfile);
            this.requestHandler.init(map);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "initialization failed.", new Object[0]);
            throw new Fault((Throwable)ex);
        }
        this.handleSecureMessage(message, (SOAPMessageContext)context, cred, subject, sharedMap);
    }

    protected abstract void handleSecureMessage(SoapMessage var1, SOAPMessageContext var2, ThreadLocal<Subject> var3, Subject var4, Map<Object, Object> var5);

    protected XMLStreamReader getSOAPReader(SOAPMessageContext context) throws SOAPException, XMLStreamException {
        DOMSource source = new DOMSource((Node)context.getMessage().getSOAPPart().getEnvelope().getBody());
        XMLStreamReader soapReader = StaxUtils.createXMLStreamReader((Source)source);
        soapReader.nextTag();
        soapReader.nextTag();
        return soapReader;
    }

    public void setRequestHandler(SOAPRequestHandlerInterface requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void setWspProfile(String wspProfile) {
        this.wspProfile = wspProfile;
    }
}

