/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authz.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import jp.co.ogis_ri.citk.common.exception.FedletException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.ExceptionUtil;
import org.apache.commons.io.IOUtils;

public class AuthzUtil {
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();

    private AuthzUtil() {
    }

    public static String createFedletUrl(String authzUrl, String spEntityId, String action, String idpEntityId, String nameId, String resource) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(authzUrl + "?");
        sb.append("spEntityID=" + spEntityId + "&");
        sb.append("action=" + action + "&");
        sb.append("idpEntityID=" + idpEntityId + "&");
        sb.append("nameIDValue=" + URLEncoder.encode(nameId, "UTF-8") + "&");
        sb.append("resource=" + URLEncoder.encode(resource, "UTF-8"));
        return sb.toString();
    }

    public static String getDecisionForFedlet(String urlString) {
        String response = AuthzUtil.AuthorizeForFedlet(urlString);
        String decision = null;
        if (response.indexOf("Permit") != -1) {
            decision = "Permit";
        } else if (response.indexOf("Deny") != -1) {
            decision = "Deny";
        } else if (response.indexOf("Indeterminate") != -1) {
            decision = "Indeterminate";
        }
        return decision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String AuthorizeForFedlet(String urlString) {
        String ret = null;
        HttpURLConnection conn = null;
        try {
            conn = AuthzUtil.createConnection(AuthzUtil.createURL(urlString));
            AuthzUtil.checkResponseCode(urlString, conn);
            ret = AuthzUtil.readResponse(conn.getInputStream());
        }
        catch (IOException e) {
            opLogger.debug((Throwable)e);
            ExceptionUtil.convertRuntimeException((Throwable)e);
        }
        finally {
            AuthzUtil.disconnect(conn);
        }
        return ret;
    }

    private static void checkResponseCode(String urlString, HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new FedletException("\u8a8d\u53ef\u7d50\u679c\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093", urlString, "HTTP Status code : " + responseCode, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResponse(InputStream inputStream) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    private static HttpURLConnection createConnection(URL url) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        return conn;
    }

    private static URL createURL(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            opLogger.debug((Throwable)e);
            ExceptionUtil.convertRuntimeException((Throwable)e);
        }
        return url;
    }

    private static void disconnect(HttpURLConnection conn) {
        if (conn != null) {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

