/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.exception.FedletException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.DataUtil;
import jp.co.ogis_ri.citk.common.util.ExceptionUtil;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.util.StringUtils;

public class AuthzTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();
    private static final String POLICY_TAG = "<th>Policy Decision</th>";
    private static final String FEDLET_IDPENTITYID_PARAM = "&idpEntityID=";
    private static final String FEDLET_RESOURCE_PARAM = "&resource=";
    private static final String FEDLET_ACTION_PARAM = "&action=";
    private static final String FEDLET_NAMEID_PARAM = "&nameIDValue=";
    private String requestUrl = null;
    private String address = null;

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String messageID = message.getUniqueId();
        String requestPath = (String)message.getInboundProperty("http.request.path");
        String resource = this.address + requestPath;
        String nameId = (String)message.getSessionProperty("nameId");
        String encodedNameId = null;
        try {
            encodedNameId = URLEncoder.encode(nameId, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.debug((Object)e1);
            ExceptionUtil.convertRuntimeException((Throwable)e1);
        }
        String method = (String)message.getInboundProperty("http.method");
        String idpEntityId = DataUtil.getCookieValue((Object)message.getInboundProperty("cookies"), (String)"idpEntityId");
        String url = this.buildUrl(resource, encodedNameId, method, idpEntityId);
        opLogger.info("I-0201", new Object[]{messageID, idpEntityId, method, nameId, resource});
        String response = null;
        response = this.fedletAuthrization(url);
        if (response == null) {
            throw new CitkSystemException("\u8a8d\u53ef\u7d50\u679c\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093", message);
        }
        if (!response.contains(POLICY_TAG)) {
            throw new FedletException("E-0105", url, response, new Object[0]);
        }
        String authzResult = StringUtils.substringAfter((String)response, (String)POLICY_TAG);
        if (authzResult == null || authzResult.isEmpty()) {
            throw new FedletException("E-0105", url, response, new Object[0]);
        }
        String decision = this.getPolicyDecision(authzResult);
        if (decision == null) {
            throw new FedletException("E-0106", url, response, new Object[0]);
        }
        opLogger.info("I-0202", new Object[]{messageID, decision});
        message.setProperty("authz.result", (Object)decision, PropertyScope.SESSION);
        return message;
    }

    private String buildUrl(String resource, String encodedNameId, String method, String idpEntityId) {
        return this.requestUrl + FEDLET_IDPENTITYID_PARAM + idpEntityId + FEDLET_RESOURCE_PARAM + resource + FEDLET_ACTION_PARAM + method + FEDLET_NAMEID_PARAM + encodedNameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fedletAuthrization(String urlString) {
        String body = null;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.logger.debug((Object)e);
            ExceptionUtil.convertRuntimeException((Throwable)e);
        }
        HttpURLConnection urlconn = null;
        BufferedReader reader = null;
        try {
            String line;
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setRequestMethod("GET");
            urlconn.setInstanceFollowRedirects(false);
            urlconn.connect();
            int responseCode = urlconn.getResponseCode();
            if (responseCode != 200) {
                throw new FedletException("\u8a8d\u53ef\u7d50\u679c\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093", urlString, "HTTP Status code : " + responseCode, new Object[0]);
            }
            reader = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            body = sb.toString();
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
            ExceptionUtil.convertRuntimeException((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            try {
                if (urlconn != null) {
                    urlconn.disconnect();
                }
            }
            catch (Exception e) {}
        }
        return body;
    }

    private String getPolicyDecision(String data) {
        String decision = null;
        if (data.indexOf("Permit") != -1) {
            decision = "Permit";
        } else if (data.indexOf("Deny") != -1) {
            decision = "Deny";
        } else if (data.indexOf("Indeterminate") != -1) {
            decision = "Indeterminate";
        }
        return decision;
    }
}

