/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.common.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleMessage;

public class RequestParameterCache {
    private static RequestParameterCache me = new RequestParameterCache();
    private Map<String, MuleMessage> cache = new ConcurrentHashMap<String, MuleMessage>();
    private Map<String, Object> payloardCache = new ConcurrentHashMap<String, Object>();

    protected RequestParameterCache() {
    }

    public void setCache(Map<String, MuleMessage> cache) {
        this.cache = null;
        this.cache = cache;
        this.payloardCache = null;
        this.payloardCache = new ConcurrentHashMap<String, Object>();
        Set<String> cacheSet = cache.keySet();
        for (String name : cacheSet) {
            this.payloardCache.put(name, cache.get(name).getPayload());
        }
    }

    public Map<String, MuleMessage> getCache() {
        return this.cache;
    }

    public void add(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (key.isEmpty()) {
            return;
        }
        MuleMessage message = null;
        if (!MuleMessage.class.isInstance(value)) {
            return;
        }
        message = (MuleMessage)value;
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, message);
            this.payloardCache.put(key, message.getPayload());
        }
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
            this.payloardCache.remove(key);
        }
    }

    public synchronized void update(String key, Object value) {
        this.remove(key);
        this.add(key, value);
    }

    public MuleMessage get(String key) {
        if (key == null) {
            return null;
        }
        MuleMessage val = null;
        if (this.cache.containsKey(key)) {
            val = this.cache.get(key);
            val.setPayload(this.payloardCache.get(key));
        }
        return val;
    }

    public static RequestParameterCache getInstance() {
        return me;
    }
}

