/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.transport.http.CookieHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DataUtil {
    private static final String NAMEID_TAG = "saml:NameID";
    private static final String SUBJECT_CONFIRMATION_DATA_TAG = "saml:SubjectConfirmationData";
    private static final String SUBJECT_CONFIRMATION_TAG = "saml:SubjectConfirmation";
    private static final String SUBJECT_TAG = "saml:Subject";
    private static final String NOT_ON_OR_AFTER_NAME = "NotOnOrAfter";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";

    private DataUtil() {
    }

    public static String getCookieValue(Object cookies, String cookiename) {
        if (cookies == null || cookiename == null || cookiename.isEmpty()) {
            return null;
        }
        return CookieHelper.getCookieValueFromCookies((Object)cookies, (String)cookiename);
    }

    public static Document parseDocument(String src) throws ParserConfigurationException, IOException, SAXException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(src.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        return parser.parse(in);
    }

    public static String getNameId(Document document) throws Exception {
        String value = null;
        NodeList elms = document.getElementsByTagName(NAMEID_TAG);
        if (elms != null && elms.getLength() == 1 && elms.item(0) != null) {
            value = elms.item(0).getTextContent();
        }
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static String getNameId(String src) throws Exception {
        Document document = DataUtil.parseDocument(src);
        return DataUtil.getNameId(document);
    }

    public static String getNameId(Object value) throws Exception {
        if (Document.class.isInstance(value)) {
            return DataUtil.getNameId((Document)value);
        }
        if (String.class.isInstance(value)) {
            return DataUtil.getNameId((String)value);
        }
        return null;
    }

    public static String getExpierDateTime(Document document) throws Exception {
        NodeList elms = document.getElementsByTagName(SUBJECT_CONFIRMATION_DATA_TAG);
        String value = null;
        Node node = null;
        for (int i = 0; i < elms.getLength(); ++i) {
            node = elms.item(i).getParentNode();
            if (node == null || !node.getNodeName().equals(SUBJECT_CONFIRMATION_TAG) || (node = node.getParentNode()) == null || !node.getNodeName().equals(SUBJECT_TAG)) continue;
            node = elms.item(i).getAttributes().getNamedItem(NOT_ON_OR_AFTER_NAME);
            value = node.getNodeValue();
        }
        return value;
    }

    public static String getExpierDateTime(String src) throws Exception {
        Document document = DataUtil.parseDocument(src);
        return DataUtil.getExpierDateTime(document);
    }

    public static String getExpierDateTime(Object value) throws Exception {
        if (Document.class.isInstance(value)) {
            return DataUtil.getExpierDateTime((Document)value);
        }
        if (String.class.isInstance(value)) {
            return DataUtil.getExpierDateTime((String)value);
        }
        return null;
    }

    public static Date parseStringToDate(String str) throws ParseException {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
        int len = "yyyy-MM-ddTHH:mm:ss".length();
        Date date = null;
        String data = null;
        String offset = null;
        if (str != null && str.length() > len) {
            data = str.substring(0, len);
            offset = str.substring(len).replace(":", "");
        }
        if ("Z".equals(offset)) {
            offset = "+0000";
        }
        if (data != null && offset != null) {
            date = fmt.parse(data + offset);
        }
        return date;
    }
}

