/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.common.transformer.saml2;

import java.net.URI;
import java.net.URISyntaxException;
import jp.co.ogis_ri.citk.common.exception.IllegalRequestException;
import jp.co.ogis_ri.citk.common.util.ExceptionUtil;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class ReceiveRelayStateTransformer
extends AbstractMessageTransformer {
    public static final String KEY = "RelayState=";

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String method = (String)message.getInboundProperty("http.method");
        String queryString = null;
        String relayState = null;
        queryString = this.getQueryString(message, method);
        if (queryString == null) {
            throw new IllegalRequestException("E-0003", message, new Object[0]);
        }
        if (queryString.contains(KEY)) {
            int startPosition = queryString.indexOf("&RelayState=") + KEY.length() + 1;
            int endPosition = queryString.indexOf("&", startPosition);
            if (endPosition < 0) {
                endPosition = queryString.length();
            }
            if (startPosition < endPosition) {
                relayState = queryString.substring(startPosition, endPosition);
            }
        }
        if (relayState == null) {
            throw new IllegalRequestException("E-0003", message, new Object[0]);
        }
        message.setSessionProperty("citk.relaystate", relayState);
        return message;
    }

    private String getQueryString(MuleMessage message, String method) {
        String query = null;
        if ("GET".equals(method)) {
            URI uri = null;
            try {
                uri = new URI((String)message.getInboundProperty("http.request", (Object)""));
            }
            catch (URISyntaxException e) {
                this.logger.debug((Object)e);
                throw ExceptionUtil.convertRuntimeException(e);
            }
            query = uri.getRawQuery();
        } else if ("POST".equals(method)) {
            try {
                query = (String)message.getPayload(DataTypeFactory.STRING);
            }
            catch (TransformerException e) {
                this.logger.debug((Object)e);
                throw ExceptionUtil.convertRuntimeException(e);
            }
        }
        return query;
    }
}

