<?php
/*-----------------------------------------------------------------------------
cheetan is licensed under the MIT license.
copyright (c) 2006 cheetan all right reserved.
http://www.cheetan.net/
-----------------------------------------------------------------------------*/
define( "DBKIND_MYSQL", "0" );
define( "DBKIND_PGSQL", "1" );


class CDatabaseConfig extends CObject
{
	var	$host;
	var	$user;
	var $pswd;
	var	$db;
	var $kind;
}


class CDatabase extends CObject
{
	var	$config			= array();
	var $connect		= array();
	var	$driver			= array();
	var $class			= array( 	"CDBMysql",
									"CDBPgsql" );
	
	
	function add( $name, $host, $user, $pswd, $db, $kind = 0 )
	{
		$config	= new CDatabaseConfig();
		$config->host			= $host;
		$config->user			= $user;
		$config->pswd			= $pswd;
		$config->db				= $db;
		$config->kind			= $kind;
		if( empty( $this->driver[$kind] ) )
		{
			$str	= '$this->driver[$kind] = new ' . $this->class[$kind] . '();';
			eval( $str );
		}
		$this->config[$name]	= $config;
	}
	
	
	function connect()
	{
		foreach( $this->config as $name => $config )
		{
			$connect	= $this->driver[$config->kind]->connect( $config->host, $config->user, $config->pswd, $config->db );
			if( !$connect )
			{
				print "Failed connect to $name.<br>";
			}
			$this->connect[$name] = $connect;
		}
	}
	
	
	function query( $query, $name = "" )
	{
		$ret	= $this->driver[$this->config[$name]->kind]->query( $query, $this->connect[$name] );
		if( !$ret )
		{
			print "[DBERR] $query<BR>";
		}
		
		return $ret;
	}
	
	
	function find( $query, $name = "" )
	{
		return $this->driver[$this->config[$name]->kind]->find( $query, $this->connect[$name] );
	}
	
	
	function count( $query, $name = "" )
	{
		return $this->driver[$this->config[$name]->kind]->count( $query, $this->connect[$name] );
	}
}
?>