/*
   ѥȥꥷںץ for 
*/

#include <stdio.h>
#include <string.h>
#include "pat.h"

#define CHA_FILENAME_LEN 1024

extern pat_t *Pat_dicfile[];
extern int Pat_ndicfile;

static char line[50000]; /* Ϲ */
static char inkey[10000]; /*  */
static char kugiri[2]; /* ڤʸ */

/****************************************************
*                      USAGE                        *
****************************************************/
static void usage(void)
{
    printf("pattool  Ver.1.1  96/10/28\n");
    printf("USAGE:\n");
    printf("\tNo option    ---  Interpreter Mode\n");
    printf("\t-F filename  ---  Make PAT file (\"filename.pat\")\n");
    exit(1);
}


/****************************************************
*  ե뤫ѥڤ
****************************************************/
static void make_pat_from_file(char *textname)
{
    if ((Pat_dicfile[Pat_ndicfile] = pat_open(textname, NULL))
	== NULL) {
	fprintf(stderr,"No such File\n");
	exit(1);
    }

    insert_dic_data(Pat_dicfile[Pat_ndicfile], kugiri);
    Pat_ndicfile++;
}


/****************************************************
*                      ᥤ                       *
****************************************************/
int main(int argc, char *argv[])
{
    char comm;
    int i;
    char *rslt[500];
    char *op;   /* ޥɥ饤󥪥ץ̾ */
    char strtmp[1000];
    char textname[CHA_FILENAME_LEN];
    char patname[CHA_FILENAME_LEN];

    Pat_ndicfile = 0; /* Ѥ뼭(ѥ)ο */

    kugiri[0] = '\t'; /* ڤʸΥǥեȤϥ */

    /* ޥɥ饤󥪥ץ */
    if (argc != 1)  /* ץ󤬤С */
	for (argv++; *argv && argv[0][0] == '-' && argv[0][1]; argv++) {
	    for (op = &argv[0][1]; *op; op++) {
		switch (*op) {
		case 'F': /* PATե򤤤ʤäƥ */
		    if (!*++argv)
			usage();
		    printf("Make Index File \"%s.pat\" from \"%s.int\"\n",
			   *argv, *argv);
		    /* ե륪ץ  ѥڤŤ*/
		    sprintf(textname, "%s.int", *argv);
		    make_pat_from_file(textname);
		    /* ѥڥ */
		    sprintf(patname, "%s.pat", *argv);
		    pat_save(Pat_dicfile[0], patname);
		    exit(0);
		default: /* Ȥ */
		    usage();
		}
	    }
	}

    printf("PATTOOL for ChaSen1.0     Ver.1.1  Feb. 1997\n");
    printf("Interpreter Mode:  \'q\' exit, '?\' help\n");

    /* ޥɥ󥿥ץ꥿ */
    while (1) {
	printf("> "); fflush(stdout);

	fgets(line, sizeof(line), stdin); /* ޥɤ */

	sscanf(line,"%c %s", &comm, inkey); 
	switch(comm) {

	case 'F': /* ե뤫 */
	    sprintf(textname, "%s.int", inkey);
	    make_pat_from_file(textname);
	    break;

	case 'e': /* θ(exact match) */
	    if (Pat_ndicfile == 0) { /* 顼 */
		fprintf(stderr,
			"!!! make or load PAT data before SEARCH.\n");
		break;
	    }
	    rslt[0] = '\0';/*ѿ*/
	    for (i = 0; i < Pat_ndicfile; i++) {
		pat_search_exact(Pat_dicfile[i], inkey, rslt);
	    }
	    printf("%s", rslt[0]);
	    break;

	case 'j': /* ʸμ(ChaSenʳ) */
	    if (Pat_ndicfile == 0){ /* 顼 */
		fprintf(stderr,
			"!!! make or load PAT data before SEARCH.\n");
		break;
	    }
	    jisyohiki(inkey);
	    break;

	case 'k': /* ڤʸ */
	    kugiri[0] = inkey[0];
	    if (kugiri[0] == '\0')
		kugiri[0] = ' ';
	    printf("partition = \"%s\"\n", kugiri);
	    break;

	case 'O': /* ڤν */
	    inkey[0] = '\0';
	    pat_show_patfile(Pat_dicfile[0], stdout, inkey); /* ɸ */
	    break;

	case 'S': /* ڤΥ */
	    strcat(inkey, ".pat");
	    pat_save(Pat_dicfile[0], inkey);
	    break;

	case 'L': /* ڤΥ */
	    strcpy(strtmp, inkey);
	    sprintf(textname, "%s.int", inkey);
	    sprintf(patname, "%s.pat", inkey);
	    /* ѥΥץ */
	    Pat_dicfile[Pat_ndicfile] = pat_open(textname, patname);
	    Pat_ndicfile++;
	    break;

	case 'q': /* 󥿥ץ꥿νλ */
	case 'Q': /* 󥿥ץ꥿νλ */
/*      th_show_hash(hash_array,HASH_SIZE);*/
	    printf("QUIT\n");
	    return(0);

	default: /* إ */
	    printf("command:\n\
              \tj [string] --- ChaSen search\n\
              \te [string] --- exact match search\n\
              \tF [file] --- make patricia tree from file\n\
              \tS [file] --- save patricia tree\n\
              \tL [file] --- load patricia tree\n\
              \tk [char] --- set partition character\n\
              \tq --- quit\n");
	    break;
	}

	printf("ok\n"); fflush(stdout);  /* ץץ */
    }
}
