<?php
/**
* HTTPץ
*
* PHP version 5
*
* @package    procedures
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class HttpProcedure extends CharcoalComponent implements IProcedure
{
	private $_tasks;
	private $_input_filters;
	private $_output_filters;
	private $_renderer;
	private $_task_manager;
	private $_page_selector;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct( String $name = NULL )
	{
		parent::__construct(s($name));
	}

	/*
	 * ץ
	 */
	public function init( Config $config )
	{
		$this->_tasks               = $config->getArray( s('tasks') );
		$this->_output_filters      = $config->getArray( s('output_filters') );
		$this->_input_filters       = $config->getArray( s('input_filters') );
		$this->_renderer            = $config->getString( s('renderer') );
		$this->_task_manager        = $config->getString( s('task_manager') );
		$this->_page_selector       = $config->getString( s('page_selector') );

		if ( !$this->_page_selector ){
			_throw( new ProcedureConfigException( 'page_selector', 'mandatory' ) );
		}
	}

	/*
	 * ץ¹Ԥ
	 */
	public function execute( IRequest $request, Response $response )
	{
		$proc_name = parent::getName();

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// åκ
		//

		if ( Profile::getBoolean( s('USE_SESSION') ) ){
			// å
			$session = new Session();

			// åγ
			$session->start();
			$session->restore();
		}

		//=======================================
		// ޥ͡κ
		//

		// ޥ͡
		$task_manager_name = $this->_task_manager;
		$task_manager = Factory::createTaskManager( $task_manager_name );

		//=======================================
		// Ͽ
		//

		foreach( $this->_tasks as $task_name ){
			$task_manager->registerTask( s($task_name) );
			log_info( "event",  "ޥ͡˥[$task_name]Ͽޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// ơȥե륿
		//

		if ( Profile::getBoolean( s('USE_SESSION') ) ){
			$task_manager->restoreStatefulTasks( $session );
		}

		//=======================================
		// ϥե륿μ¹
		//

		if ( $this->_input_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

			foreach( $this->_input_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}
	
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// ٥ȥǥѥå
		//

		$task_manager->dispatchEvents( $request );

		//=======================================
		// ٥Ƚ
		//

		$task_manager->processEvents();

		//=======================================
		// ڡ
		//

		// ڡ쥯κ
		$page_selector_name = $this->_page_selector;
		$page_selector = Factory::createPageSelector( $page_selector_name );
		// ڡ
		$page = $page_selector->selectPage( $proc_name, $task_manager->getSnapshot(), $response );

		//=======================================
		// ϥե륿μ¹
		//
		if ( $this->_output_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

			foreach( $this->_output_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( s($filter_name) );
				// ե륿μ¹
				$filter->filter( $request, $response );
			}

			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// μ¹
		//
		if ( $this->_renderer && strlen($this->_renderer) > 0 ) {
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

			$renderer = Factory::createRenderer( $this->_renderer );
			if ( $renderer ) {
				$renderer->render( $page, $response );
			}
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

		}

		//=======================================
		// λ
		//

		// å¸
		if ( Profile::getBoolean( s('USE_SESSION') ) ) {

			// ơȥե륿¸
			$task_manager->saveStatefulTasks( $session );

			// å¸
			$session->save();
			$session->close();
		}

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );
	}
}

return __FILE__;