<?php
/**
* SQLӥ륤󥿥ե
*
* PHP version 5
*
* @package    interfaces
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

interface ISQLBuilder extends IObject
{
	/**
	 *  SQLӥ
	 */
	public function init( Config $config );

	/*
	 *	SQL(SELECT)
	 */
	public  function buildSelectSQL( ITableModel $model, SQLCriteria $criteria = NULL );

	/*
	 *	SQL(UPDATE)
	 */
	public  function buildUpdateSQL( ITableModel $model, DTO $dto );

	/*
	 *	SQL(INSERT)
	 */
	public  function buildInsertSQL( ITableModel $model, DTO $dto );

	/*
	 *	SQL(count)
	 */
	public  function buildCountSQL( ITableModel $model, SQLCriteria $criteria = NULL );

	/*
	 *	SQL(max)
	 */
	public  function buildMaxSQL( ITableModel $model, String $field, SQLCriteria $criteria = NULL );

	/*
	 *	SQL(DELETE)
	 */
	public  function buildDeleteSQL( ITableModel $model, SQLCriteria $criteria = NULL );

	/*
	 *	SQL(LAST_INSERT_ID)
	 */
	public  function buildLastIdSQL();

	/*
	 *	SQL(CREATE DATABASE)
	 */
	public  function buildCreateDatabaseSQL( String $db_name, String $charset = NULL );

	/*
	 *	SQL(CREATE TABLE)
	 */
	public  function buildCreateTableSQL( ITableModel $model );
}

return __FILE__;