<?php
/**
* ñʥե륯饹
*
* PHP version 5
*
* @package    forms
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/


class SimpleForm extends CharcoalComponent implements IForm
{
	var $_dto;
	var $_model;
	var $_transformer;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/*
	 * ե
	 */
	public function init( Config $config )
	{
		$model_class                = $config->getString( s('model_class') );
		$transformer_name           = $config->getString( s('transformer_name') );
		$this->_auto_input_request  = $config->getBoolean( s('auto_input_request') );
		$this->_auto_output         = $config->getBoolean( s('auto_output') );

		// եǥ
		$this->_model = ClassUtil::newInstance( $model_class );
		
		// ȥ󥹥եޤ
		$this->_transformer = Factory::createTransformer( $transformer_name );

		// ǥ뤫DTO
		$this->_dto = $this->_model->createDTO();
	}

	/*
	 * եǥ
	 */
	public function getFormModel()
	{
		return $this->_model;
	}

	/*
	 * եǡ
	 */
	public function get( $key )
	{
		return $this->_form_values[ $key ];
	}

	/*
	 * ե˴Ϣդ줿DTO
	 */
	public function getDTO()
	{
		return $this->_dto;
	}

	/*
	 * ꥯȼưϤ뤫
	 */
	public function isAutoInputRequest()
	{
		return $this->_auto_input_request;
	}

	/*
	 * ưϤ뤫
	 */
	public function isAutoOutput()
	{
		return $this->_auto_output;
	}

	/*
	 * եХǡԤ
	 */
	public function validate()
	{
		return true;
	}

	/*
	 * DTOեϤԤ
	 */
	public function inputDTO( DTO $dto, IModel $model = NULL )
	{
		// ѴDTO顢FormModelؤѴԤ
		if ( $model ){
			$dto = $this->_transformer->transform( $dto, $model, new DTO(), $this->_model );
		}

		$this->_dto = $dto;
	}

	/*
	 * EventեϤԤ
	 */
	public function inputEvent( IEvent $event )
	{
		$conv = EncodingConverter::fromString( 'HTML_TO_PHP' );

		$model = $this->_model;
		$dto = new DTO();

		$fields = $model->getFieldList();
		if ( $fields ){
			foreach( $fields as $field ){
				$value = $event->get( s($field) );

				if ( is_string($value) ){
					$value = $conv->convertEncoding( $value );
				}

				$dto->$field = $value;
			}
		}

		$this->_dto = $dto;
	}

	/*
	 * եͤDTOѴ
	 */
	public function toDTO( IModel $model )
	{
		// ѴDTO顢FormModelؤѴԤ
		return $this->_transformer->transform( $this->_dto, $this->_model, new DTO(), $model );
	}

	/*
	 * HTML֥ȤѴ
	 */
	public function toHTMLObject( $read_only = FALSE )
	{
		return HTMLFormFactory::create( $this->_model, $this->_dto, $read_only );
	}
}

return __FILE__;