<?php
/**
* Ķ̤򰷤饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Profile
{
	static $config_file;
	static $config;
	static $profile_name;

	/*
	 * ץե̾
	 */
	public static function getProfileName()
	{
		return self::$profile_name;
	}

	/*
	 * 
	 */
	public static function getKeys()
	{
		return array_keys( self::$config );
	}

	/*
	 * ե̾
	 */
	public static function getConfigFile()
	{
		return self::$config_file;
	}

	/*
	 * ХͤȤƼ
	 */
	public static function getInteger( String $key, $defaultValue = NULL )
	{
		if ( !isset(self::$config["$key"]) ){
			return i($defaultValue);
		}
		$value = i(self::$config["$key"]);
		return $value;
	}

	/*
	 * ХͤʸȤƼ
	 */
	public static function getString( String $key, $default_value = NULL )
	{
		// ̤ʤʸ֤
		if ( !isset(self::$config[ "$key" ]) ){
			return $default_value !== NULL ? $default_value : new String('');
		}

		// ͤ
		$value = self::$config[ "$key" ];

		// եޥåȳǧ
		if ( !is_string($value) ){
			_throw( new StringFormatException( $value, "key=[$key]" ) );
		}

		$value = s($value);

		// ֵ
		return ConfigUtil::processMacro($value);
	}

	/*
	 * Хͤ֡ͤȤƼ
	 */
	public static function getBoolean( String $key, $default_value = NULL  )
	{
		if ( !isset(self::$config[ "$key" ]) ){
			return $default_value !== NULL ? $default_value : new Boolean(FALSE);
		}

		// ͤ
		$value = self::$config[ "$key" ];

		if ( is_string($value) ){
			$value = (strlen($value) > 0 );
		}

		// եޥåȳǧ
		if ( !is_bool($value) ){
			_throw( new BooleanFormatException( $value, "key=[$key]" ) );
		}

		// ֡뷿ˤֵ
		return b($value);
	}

	/*
	 * ХͤȤƼ
	 */
	public static function getArray( String $key, $default_value = NULL )
	{

		// ̤ʤ֤
		if ( !isset(self::$config[ "$key" ]) ){
			return $default_value !== NULL ? $default_value : new Vector();
		}

		// ͤ
		$value = self::$config[ "$key" ];

		// ޤʬ
		$array = explode( ',', $value );

		// ζ
		foreach( $array as $key => $value ){
			$array[$key] = trim($value);
		}

		// ǤĤǶʤǥե֤ͤ
		if ( count($array) == 1 && $array[0] === '' ){
			return $default_value;
		}

		// եޥåȳǧ
		if ( !is_array($array) ){
			_throw( new ArrayFormatException( $value, "key=[$key]" ) );
		}

		// ֵ
		return  v($array);
	}

	/*
	 * Хեɤ߹
	 */
	public static function load( $profile_name )
	{
		// եξ
		$config_file = _webapp_path( s('config/profiles'), s("$profile_name.global.ini") );

		// sectionʤiniեѡ
		$config = parse_ini_file($config_file,FALSE);

		// ץե̾
		if ( $config['PROFILE_NAME'] ){
			$profile_name = $config['PROFILE_NAME'];
		}

		// ¸
		self::$config = $config;
		self::$config_file = basename($config_file);
		self::$profile_name = $profile_name;

	}
}

return __FILE__;