<?php
/**
* ե륯饹
*
* PHP version 5
*
* @package    filters
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class File extends Object
{
	private $_path;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( String $path )
	{
		parent::__construct();

		$this->_path = "$path";
	}

	/*
	 *    ɤ߼ǽ
	 */
	public function canRead()
	{
		return is_readable($this->_path);
	}

	/*
	 *    񤭹߲ǽ
	 */
	public function canWrite()
	{
		return is_writeable( $this->_path );
	}

	/*
	 *    
	 */
	public function delete()
	{
		return unlink( $this->_path );
	}

	/*
	 *    ݥѥ
	 */
	public function getPath()
	{
		return $this->_path;
	}

	/*
	 *    ե뤫
	 */
	public function isFile()
	{
		return is_file( $this->_path );
	}

	/*
	 *    ǥ쥯ȥ꤫
	 */
	public function isDir()
	{
		return is_dir( $this->_path );
	}

	/*
	 *    ǥ쥯ȥ꤫
	 */
	public function isDirectory()
	{
		return is_dir( $this->_path );
	}

	/*
	 *    եޤϥǥ쥯ȥ꤬¸ߤ뤫
	 */
	public function exists()
	{
		return file_exists( $this->_path );
	}

	/*
	 *    Хѥ
	 */
	public function getAbsolutePath()
	{
		return realpath( $this->_path );
	}

	/*
	 *    ե̾
	 */
	public function getName()
	{
		return basename( $this->_path );
	}

	/*
	 *    ե뤬ǼƤǥ쥯ȥ̾
	 */
	public function getDirName()
	{
		return dirname( $this->_path );
	}

	/*
	 *    Υǥ쥯ȥ
	 */
	public function makeDirectory( $drilldown = FALSE )
	{
		if ( $drilldown ){
			$path = $this->_path;

			$dirs = explode( '/', $path );
			array_shift($dirs);		// Ƭ/ϼΤƤ

			$path = '/';
			while( ($dir=array_shift($dirs)) !== NULL ){
				if ( strlen($path) > 1 ){
					$path .= '/';
				}
				$path .= "$dir";
				if ( !file_exists($path) ){

					if ( !mkdir($path) ){
						_throw( new MakeDirectoryException($path) );
					}
				}
			}
		}
		else{
			if ( !mkdir( $this->_path ) ){
				_throw( new MakeDirectoryException($this->_path) );
			}
		}
	}




}

return __FILE__;