<?php
/**
* DBѤ륿
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

abstract class DatabaseTask extends Task implements ITask
{
	private $_gw;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_gw = new SmartGateway();
	}

	/*
	 *	ǡ
	 */
	public function getDataSource()
	{
		return $this->_gw->getDataSource();
	}

	/*
	 *	SQLӥ
	 */
	public function getSQLBuilder()
	{
		return $this->_gw->getSQLBuilder();
	}

	/*
	 *	³
	 */
	public function refresh()
	{
		$this->_gw->refresh();
	}

	/*
	 *	ơ֥ǥμ
	 */
	public function getModel( String $model_name )
	{
		return $this->_gw->getModel( $model_name );
	}

	/*
	 *	¸
	 */
	public  function save( String $model_name, DTO $dto, String $converter_str = NULL )
	{
		return $this->_gw->save( $model_name, $dto, $converter_str );
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( String $sql, Vector $params = NULL )
	{
		return $this->_fw->execute( $sql, $params );
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( String $sql, Vector $params = NULL, String $converter_str = NULL )
	{
		return $this->_gw->query( $sql, $params, $converter_str );
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( String $model_name, $sql, $params = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findBySQL( $model_name, $sql, $params, $converter_str );
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( DTO $dto, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findFirst( $dto, $criteria, $converter_str );
	}

	/*
	 *	
	 */
	public  function findAll( String $model_name, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findAll( $model_name, $criteria, $converter_str );
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( String $model_name, $field, $value, SQLCriteria $criteria = NULL, $converter_str = NULL )
	{
		return $this->_gw->findAllBy( $model_name, $field, $value, $criteria, $converter_str );;
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( String $model_name, String $id, $converter_str = NULL ) 
	{
		return $this->_gw->findByID( $model_name, $id, $converter_str );;
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( String $model_name, Vector $id_array ) 
	{
		return $this->_gw->findAllByID( $model_name, $id_array );
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( String $model_name, String $id ) 
	{
		$this->_gw->destroyById( $model_name, $id );
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( String $model_name, Vector $id_array ) 
	{
		$this->_gw->destroyAllById( $model_name, $id_array );
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( String $model_name, String $field, $value )
	{
		$this->_gw->destroyBy( $model_name, $field, $value );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( String $model_name, String $where_clause = NULL, Vector $params = NULL ) 
	{
		$this->destroyAll( $model_name, $where_clause, $params );
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( String $model_name, String $where_clause = NULL, Vector $params = NULL ) 
	{
		return $this->_gw->count( $model_name, $where_clause, $params );
	}

	/*
	 *	եɤκͤ
	 */
	public  function max( String $model_name, String $field, String $where_clause = NULL, Vector $params = NULL ) 
	{
		return $this->gw->max( $model_name, $field, $where_clause, $params );
	}


	/*
	 *	DB
	 */
	public  function createDatabase( String $db_name, String $charset ) 
	{
		$this->_gw->createDatabase( $db_name, $charset );
	}

	/*
	 *	ơ֥
	 */
	public  function createTable( String $model_name ) 
	{
		$this->_gw->createTable( $model_name );
	}
}


return __FILE__;