<?php
/**
* Smarty
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'Smarty/Smarty.class.php' );

class SmartyRenderer extends CharcoalComponent implements IRenderer
{
	var $_template_files;
	var $_smarty;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_template_files = array();
		$this->_smarty = new Smarty();
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function init( Config $config )
	{
		$this->_smarty->caching 		= $config->getBoolean( s('caching') )->getValue();
		$this->_smarty->compile_check 	= $config->getBoolean( s('compile_check') )->getValue();
		$this->_smarty->template_dir 	= $config->getString( s('template_dir') )->getValue();
		$this->_smarty->compile_dir 	= $config->getString( s('compile_dir') )->getValue();
		$this->_smarty->config_dir 		= $config->getString( s('config_dir') )->getValue();
		$this->_smarty->cache_dir 		= $config->getString( s('cache_dir') )->getValue();
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( String $page, Response $response )
	{
		log_info( "system",  "SmartyRendererˤ󥰤Ԥޤڡ̾[$page]", __FILE__, __LINE__ );

		try{

			// Smarty֥Ȥ
			$smarty = $this->_smarty;

			// 쥹ݥ󥹥ǡ򤹤٤Smartyassign
			$keys = $response->getKeys();
			foreach( $keys as $key ){
				$value = $response->get( s($key) );
				$smarty->assign( $key, $value );
			}

			// ƥץ졼ȤŸɽ
			$smarty->display( $page );
		}
		catch ( Exception $e )
		{
			_throw( new RendererException( "rendering failed" ) );
		}

		log_info( "system",  "SmartyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}

return __FILE__;