<?php
/**
* Curvy
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'Curvy/Curvy.class.php' );

class CurvyRenderer extends CharcoalComponent implements IRenderer
{
	var $_template_files;
	var $_curvy;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_template_files = array();
		$this->_curvy = new Curvy();
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Curvy Renderer";
	}

	/*
	 * 顼
	 */
	public function init( Config $config )
	{
		$this->_Curvy->caching 			= $config->getBoolean( 'caching' );
		$this->_Curvy->compile_check 	= $config->getBoolean( 'compile_check' );
		$this->_Curvy->template_dir 	= $config->getString( 'template_dir' );
		$this->_Curvy->compile_dir 		= $config->getString( 'compile_dir' );
		$this->_Curvy->config_dir 		= $config->getString( 'config_dir' );
		$this->_Curvy->cache_dir 		= $config->getString( 'cache_dir' );

		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $config->getAssoc( 'template_files' );
	}

	/*
	 * ƥץ졼ȥե̾
	 */
	private function getTemplateFile( $template_name )
	{
		$template_file = $this->_template_files[ $template_name ];
		if ( !$template_file ){
//$this->_config->dump();
			_throw( new TemplateFileNotFoundException( $template_name ) );
		}
		return $template_file;
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( String $page, Response $response )
	{
		log_info( "system",  "CurvyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{

			// Curvy֥Ȥ
			$curvy = $this->_curvy;

			// 쥹ݥ󥹥ǡ򤹤٤Curvyassign
			$keys = $response->getKeys();
			foreach( $keys as $key ){
				$value = $response->get( $key );
				$curvy->assign( $key, $value );
			}

			// ƥץ졼̾
			$template_name = $context->get( 'curvy_template' );

			// ƥץ졼ȥե̾Ѵ
			$template_file = $this->getTemplateFile( $template_name );

			// ƥץ졼ȤŸɽ
			$Curvy->display( $template_file );
		}
		catch ( Exception $e )
		{
			_throw( new RendererException( "rendering failed" ) );
		}

		log_info( "system",  "CurvyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}

return __FILE__;