<?php
/**
* Υեȥɥ󥿥ե
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Logger 
{
	static $loggers = array();
	static $enabled = FALSE;

	const LOGLEVEL_FATAL     = 100;		// FATAL
	const LOGLEVEL_ERROR     = 200;		// ERROR
	const LOGLEVEL_WARNING   = 300;		// WARNING
	const LOGLEVEL_INFO      = 400;		// INFO
	const LOGLEVEL_DEBUG     = 500;		// DEBUG
	const LOGLEVEL_TRACE     = 600;		// TRACE

	/**
	 * 
	 */
	public static function init()
	{
		self::$enabled = Profile::getBoolean( s('LOG_ENABLED') )->isTrue();
	}

	/**
	 * λ
	 */
	public static function terminate()
	{
		self::$enabled = FALSE;

		foreach( self::$loggers as $key => $logger ){
			$logger->terminate();
		}
	}

	/**
	 *  ͭե饰
	 */
	public static function isEnabled()
	{
		return self::$enabled;
	}

	/*
	 *	ɲ
	 */
	public static function append( $key, ILogger $logger )
	{
		// ˥å
		self::$loggers[ "$key" ] = $logger;
	}

	/*
	 *	Խ
	 */
	public static function writeln( $target, $message, $file, $line )
	{
		if ( !self::$enabled ){
			return;
		}
		
		// ٥ȥ̾
		list( $level, $logger_names ) = self::_getLevelAndTargetList( $target );

		self::_writelnAll( $level, $logger_names, $message, $file, $line );
	}
	
	/*
	 *	
	 */
	public static function writeArray( $target, $ary, $file, $line )
	{
		if ( !self::$enabled ){
			return;
		}

		// ٥ȥ̾
		list( $level, $logger_names ) = self::_getLevelAndTargetList( $target );

		foreach( $ary as $key => $value ){
			$message = "[$key]=>$value";
			self::_writelnAll( $level, $logger_names, $message, $file, $line );
		}
	}

	/*
	 *	ϿƤ٤Ƥ˥
	 */
	private static function _writelnAll( $level, $logger_names, $message, $file, $line )
	{
		// ٥
		$profile_level = Profile::getString( s('LOG_LEVEL') );

		if ( !$profile_level ){
			// LOG_LEVELꤵƤʤϡWARNINGʾ
			$profile_level = self::LOGLEVEL_WARNING;
		}

		// ץեꤷ٥ʲʤнϤʤ
		$cmp = self::_compareLogLevel($level,$profile_level);
		if ( $cmp > 0 ){
			return;
		}

		// оݥФƤΤ߽
		foreach( $logger_names as $key ){

			if ( isset( self::$loggers[ $key ] ) ){
				$logger = self::$loggers[ $key ];
				$logger->writeln( $key, $level, $message, $file, $line );
			}
		}
	}

	/*
	 *	٥ͤμ
	 *
	 */
	private static function _getLogLevelValue( $level )
	{
		switch( $level ){
		case 'F':	$ret = self::LOGLEVEL_FATAL;		break;		// FATAL
		case 'E':	$ret = self::LOGLEVEL_ERROR;		break;		// ERROR
		case 'W':	$ret = self::LOGLEVEL_WARNING;		break;		// WARNING
		case 'I':	$ret = self::LOGLEVEL_INFO;			break;		// INFO
		case 'D':	$ret = self::LOGLEVEL_DEBUG;		break;		// DEBUG
		case 'T':	$ret = self::LOGLEVEL_TRACE;		break;		// TRACE
		default:	$ret = self::LOGLEVEL_INFO;			break;		// as INFO
		}
		return $ret;
	}

	/*
	 *	٥
	 *
	 */
	private static function _compareLogLevel( $lv1, $lv2 )
	{
		$lv1 = self::_getLogLevelValue($lv1);
		$lv2 = self::_getLogLevelValue($lv2);

		return ($lv1 - $lv2);
	}

	/*
	 *	target٥ȥ̾
	 *
	 *	targetʸΥեޥåȡ
	 *
	 *  [٥]:[̾],[̾],...
	 *	ex) "I:app,debug,sql"
	 */
	private static function _getLevelAndTargetList( $target )
	{
		// ʬ
		list($level,$logger_names) = explode( ":" , "$target" );

		// ̾ꥹ
		$logger_names = explode( "," , $logger_names );

		return array( $level, $logger_names );
	}

}
return __FILE__;
