<?php
/**
* ѥå饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Stack extends Object
{
	private $_data;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( Vector $data = NULL )
	{
		parent::__construct();

		$data = $data ? $data : new Vector();

		$this->_data = $data->reverse();
	}

	/*
	 *	ƬǤ
	 */
	public function getHead()
	{
		$cnt = $this->_data->count();
		if ( $cnt > 0 ){
			return $this->_data->getHead();
		}
		_throw( new EmptyStackException( $this ) );
	}

	/*
	 *	ǸǤ
	 */
	public function getTail()
	{
		$cnt = $this->_data->count();
		if ( $cnt > 0 ){
			return $this->_data->getTail();
		}
		_throw( new EmptyStackException( $this ) );
	}

	/*
	 *	
	 */
	public function isEmpty()
	{
		return $this->_data->isEmpty();
	}

	/*
	 *	ǿ
	 */
	public function count()
	{
		return $this->_data->count();
	}

	/*
	 *	ƤǤ
	 */
	public function clear()
	{
		$this->_data = new Vector();
	}

	/*
	 *	Ǥɲ
	 */
	public function push( $item )
	{
		if ( is_null($item) ){
			_throw( new NullPointerException() );
		}
		return $this->_data->add( $item );
	}

	/*
	 *	Ǥ
	 */
	public function pop()
	{
		$tail = $this->_data->removeTail();
		if ( !$tail ){
			_throw( new EmptyStackException( $this ) );
		}
		return $tail;
	}

	/*
	 *	
	 */
	public function toArray()
	{
		return $this->_data->toArray();
	}

	/**
	 *	
	 */
	public function dump()
	{
		$this->_data->dump();
	}

}
return __FILE__;
