<?php
/**
* DBѤ륿
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

abstract class DatabaseTask extends Task implements ITask
{
	private $_gw;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_gw = new SmartGateway();
	}


	/*
	 *	ǡ
	 */
	public function getDataSource()
	{
		return $this->_gw->getDataSource();
	}

	/*
	 *	SQLӥ
	 */
	public function getSQLBuilder()
	{
		return $this->_gw->getSQLBuilder();
	}

	/*
	 *	³
	 */
	public function refresh()
	{
		$this->_gw->refresh();
	}

	/*
	 *	ơ֥ǥμ
	 */
	public function getModel( String $model_name )
	{
		return $this->_gw->getModel( $model_name );
	}

	/*
	 *	¸
	 */
	public  function save( ITableModel $model, DTO $dto, String $converter_str = NULL )
	{
		return $this->_gw->save( $model, $dto, $converter_str );
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( String $sql, Vector $params = NULL )
	{
		return $this->_fw->execute( $sql, $params );
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( String $sql, Vector $params = NULL, String $converter_str = NULL )
	{
		return $this->_gw->query( $sql, $params, $converter_str );
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( ITableModel $model, $sql, $params = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findBySQL( $model, $sql, $params, $converter_str );
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( DTO $dto, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findFirst( $dto, $criteria, $converter_str );
	}

	/*
	 *	
	 */
	public  function findAll( ITableModel $model, SQLCriteria $criteria = NULL, String $converter_str = NULL ) 
	{
		return $this->_gw->findAll( $model, $criteria, $converter_str );
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( ITableModel $model, $field, $value, SQLCriteria $criteria = NULL, $converter_str = NULL )
	{
		return $this->_gw->findAllBy( $model, $field, $value, $criteria, $converter_str );;
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( ITableModel $model, String $id, $converter_str = NULL ) 
	{
		return $this->_gw->findByID( $model, $id, $converter_str );;
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( ITableModel $model, Vector $id_array ) 
	{
		return $this->_gw->findAllByID( $model, $id_array );
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( ITableModel $model, String $id ) 
	{
		$this->_gw->destroyById( $model, $id );
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( ITableModel $model, Vector $id_array ) 
	{
		$this->_gw->destroyAllById( $model, $id_array );
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( ITableModel $model, String $field, $value )
	{
		$this->_gw->destroyBy( $model, $field, $value );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( ITableModel $model, String $where_clause = NULL, Vector $params = NULL ) 
	{
		$this->destroyAll( $model, $where_clause, $params );
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( ITableModel $model, String $where_clause = NULL, Vector $params = NULL ) 
	{
		return $this->_gw->count( $model, $where_clause, $params );
	}

	/*
	 *	եɤκͤ
	 */
	public  function max( ITableModel $model, String $field, String $where_clause = NULL, Vector $params = NULL ) 
	{
		return $this->gw->max( $model, $field, $where_clause, $params );
	}


	/*
	 *	DB
	 */
	public  function createDatabase( String $db_name, String $charset ) 
	{
		$this->_gw->createDatabase( $db_name, $charset );
	}

	/*
	 *	ơ֥
	 */
	public  function createTable( ITableModel $model ) 
	{
		$this->_gw->createTable( $model );
	}
}


return __FILE__;