<?php
/**
* PHPTAL
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once 'PHPTAL.php';

class PHPTALRenderer extends CharcoalComponent implements IRenderer
{
	var $_template_files;
	var $_repository;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_template_files = array();
		$this->_repository = NULL;
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function init( Config $config )
	{
		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $config->getArray( 'template_files' );

		// ݥȥ
		$this->_repository = $config->getString( 'repository', TRUE );
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( String $page, Response $response )
	{
		log_info( "system",  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{
			// PHPTAL֥Ȥ
			$template = new PHPTAL( $page );

			// 쥹ݥ󥹥ǡ򤹤٤assign
			$keys = $response->getKeys();
			foreach( $keys as $key ){
				$value = $response->get( $key );
				$template->$key = $value;
			}

			// ƥץ졼ȥѥ
			$template->setTemplateRepository( $this->_repository );

			// 
			echo $template->execute();

		}
		catch ( Exception $e )
		{
s			_throw( new RendererException( $proc_key, "rendering failed" ) );
		}

		log_info( "system",  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}

return __FILE__;